"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.euiButtonDisplayStyles = exports.euiButtonBaseCSS = void 0;

var _react = require("@emotion/react");

var _global_styling = require("../../../global_styling");

function _EMOTION_STRINGIFIED_CSS_ERROR__() { return "You have tried to stringify object returned from `css` function. It isn't supposed to be used directly (e.g. as value of the `className` prop), but rather handed to emotion so it can handle it (e.g. as value of `css` prop)."; }

// Provides a solid reset and base for handling sizing layout
// Does not include any visual styles
var euiButtonBaseCSS = function euiButtonBaseCSS() {
  return "\n    display: inline-block;\n    appearance: none;\n    cursor: pointer;\n    ".concat((0, _global_styling.logicalTextAlignStyle)('center'), ";\n    white-space: nowrap;\n    ").concat((0, _global_styling.logicalCSS)('max-width', '100%'), ";\n    vertical-align: middle;\n  ");
};

exports.euiButtonBaseCSS = euiButtonBaseCSS;

var _buttonSize = function _buttonSize(size) {
  return "\n    ".concat((0, _global_styling.logicalCSS)('height', size), ";\n    // prevents descenders from getting cut off\n    line-height: ").concat(size, ";\n  ");
};

var _ref = process.env.NODE_ENV === "production" ? {
  name: "15xpz7k-fullWidth",
  styles: "display:block;width:100%;label:fullWidth;"
} : {
  name: "15xpz7k-fullWidth",
  styles: "display:block;width:100%;label:fullWidth;",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};

var _ref2 = process.env.NODE_ENV === "production" ? {
  name: "8595p9-isDisabled",
  styles: "cursor:not-allowed;label:isDisabled;"
} : {
  name: "8595p9-isDisabled",
  styles: "cursor:not-allowed;label:isDisabled;",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};

var euiButtonDisplayStyles = function euiButtonDisplayStyles(euiThemeContext, minWidth) {
  var euiTheme = euiThemeContext.euiTheme;
  return {
    // Base
    euiButtonDisplay: /*#__PURE__*/(0, _react.css)(euiButtonBaseCSS(), ";", minWidth && (0, _global_styling.logicalCSS)('min-width', minWidth), ";;label:euiButtonDisplay;"),
    // States
    isDisabled: _ref2,
    fullWidth: _ref,
    // Sizes
    xs: /*#__PURE__*/(0, _react.css)(_buttonSize(euiTheme.size.l), (0, _global_styling.euiFontSize)(euiThemeContext, 'xs'), ";label:xs;"),
    s: /*#__PURE__*/(0, _react.css)(_buttonSize(euiTheme.size.xl), (0, _global_styling.euiFontSize)(euiThemeContext, 's'), ";label:s;"),
    m: /*#__PURE__*/(0, _react.css)(_buttonSize(euiTheme.size.xxl), (0, _global_styling.euiFontSize)(euiThemeContext, 's'), ";label:m;")
  };
};

exports.euiButtonDisplayStyles = euiButtonDisplayStyles;