"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

var _typeof = require("@babel/runtime/helpers/typeof");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiTextColor = exports.COLORS = void 0;

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _react = _interopRequireWildcard(require("react"));

var _clone_element = require("../../services/theme/clone_element");

var _services = require("../../services");

var _text_color = require("./text_color.styles");

var _react2 = require("@emotion/react");

var _excluded = ["children", "color", "component", "cloneElement", "style"];

function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }

function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) { symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); } keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { (0, _defineProperty2.default)(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

var COLORS = ['default', 'subdued', 'success', 'accent', 'danger', 'warning', 'ghost', 'inherit'];
exports.COLORS = COLORS;

var EuiTextColor = function EuiTextColor(_ref) {
  var children = _ref.children,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? 'default' : _ref$color,
      _ref$component = _ref.component,
      component = _ref$component === void 0 ? 'span' : _ref$component,
      _ref$cloneElement = _ref.cloneElement,
      cloneElement = _ref$cloneElement === void 0 ? false : _ref$cloneElement,
      style = _ref.style,
      rest = (0, _objectWithoutProperties2.default)(_ref, _excluded);
  var isNamedColor = COLORS.includes(color);
  var euiTheme = (0, _services.useEuiTheme)();
  var styles = (0, _text_color.euiTextColorStyles)(euiTheme);
  var cssStyles = [styles.euiTextColor, isNamedColor ? styles[color] : styles.customColor]; // We're checking if is a custom color.
  // If it is a custom color we set the `color` of the `.euiTextColor` div to that custom color.
  // This way the children text elements can `inherit` that color and border and backgrounds can get that `currentColor`.

  var euiTextStyle = !isNamedColor ? _objectSpread({
    color: color
  }, style) : _objectSpread({}, style);

  var props = _objectSpread({
    css: cssStyles,
    style: euiTextStyle
  }, rest);

  if ( /*#__PURE__*/(0, _react.isValidElement)(children) && cloneElement) {
    var childrenStyle = _objectSpread(_objectSpread({}, children.props.style), euiTextStyle);

    return (0, _clone_element.cloneElementWithCss)(children, _objectSpread(_objectSpread({}, props), {}, {
      style: childrenStyle
    }));
  } else {
    var Component = component;
    return (0, _react2.jsx)(Component, props, children);
  }
};

exports.EuiTextColor = EuiTextColor;