"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SIZES = exports.EuiSpacer = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _react = _interopRequireDefault(require("react"));

var _classnames = _interopRequireDefault(require("classnames"));

var _services = require("../../services");

var _spacer = require("./spacer.styles");

var _react2 = require("@emotion/react");

var _excluded = ["className", "size"];
var SIZES = ['xs', 's', 'm', 'l', 'xl', 'xxl'];
exports.SIZES = SIZES;

var EuiSpacer = function EuiSpacer(_ref) {
  var className = _ref.className,
      _ref$size = _ref.size,
      size = _ref$size === void 0 ? 'l' : _ref$size,
      rest = (0, _objectWithoutProperties2.default)(_ref, _excluded);
  var euiTheme = (0, _services.useEuiTheme)();
  var styles = (0, _spacer.euiSpacerStyles)(euiTheme);
  var classes = (0, _classnames.default)('euiSpacer', (0, _defineProperty2.default)({}, "euiSpacer--".concat(size), size), className);
  var cssStyles = [styles.euiSpacer, styles[size]];
  return (0, _react2.jsx)("div", (0, _extends2.default)({
    className: classes,
    css: cssStyles
  }, rest));
};

exports.EuiSpacer = EuiSpacer;