"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SIZES = exports.EuiLoadingLogo = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _react = _interopRequireDefault(require("react"));

var _classnames = _interopRequireDefault(require("classnames"));

var _icon = require("../icon");

var _services = require("../../services");

var _loading_strings = require("./_loading_strings");

var _loading_logo = require("./loading_logo.styles");

var _react2 = require("@emotion/react");

var _excluded = ["size", "logo", "aria-label", "className"];
var SIZES = ['m', 'l', 'xl'];
exports.SIZES = SIZES;

var EuiLoadingLogo = function EuiLoadingLogo(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 'm' : _ref$size,
      _ref$logo = _ref.logo,
      logo = _ref$logo === void 0 ? 'logoKibana' : _ref$logo,
      ariaLabel = _ref['aria-label'],
      className = _ref.className,
      rest = (0, _objectWithoutProperties2.default)(_ref, _excluded);
  var euiTheme = (0, _services.useEuiTheme)();
  var defaultLabel = (0, _loading_strings.useLoadingAriaLabel)();
  var styles = (0, _loading_logo.euiLoadingLogoStyles)(euiTheme);
  var cssStyles = [styles.euiLoadingLogo, styles[size]];
  var iconStyles = (0, _loading_logo.euiLoadingLogoIconStyles)(euiTheme);
  var iconCssStyles = [iconStyles.euiLoadingLogo__icon];
  var classes = (0, _classnames.default)('euiLoadingLogo', className);
  return (0, _react2.jsx)("span", (0, _extends2.default)({
    className: classes,
    css: cssStyles,
    role: "progressbar",
    "aria-label": ariaLabel || defaultLabel
  }, rest), (0, _react2.jsx)("span", {
    css: iconCssStyles
  }, (0, _react2.jsx)(_icon.EuiIcon, {
    type: logo,
    size: size
  })));
};

exports.EuiLoadingLogo = EuiLoadingLogo;