"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SIZES = exports.EuiLoadingChart = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _react = _interopRequireDefault(require("react"));

var _classnames = _interopRequireDefault(require("classnames"));

var _services = require("../../services");

var _loading_chart = require("./loading_chart.styles");

var _i18n = require("../i18n");

var _react2 = require("@emotion/react");

var _excluded = ["size", "mono", "className", "aria-label"];
var SIZES = ['m', 'l', 'xl'];
exports.SIZES = SIZES;

var EuiLoadingChart = function EuiLoadingChart(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 'm' : _ref$size,
      _ref$mono = _ref.mono,
      mono = _ref$mono === void 0 ? false : _ref$mono,
      className = _ref.className,
      ariaLabel = _ref['aria-label'],
      rest = (0, _objectWithoutProperties2.default)(_ref, _excluded);
  var defaultAriaLabel = (0, _i18n.useEuiI18n)('euiLoadingChart.ariaLabel', 'Loading');
  var euiTheme = (0, _services.useEuiTheme)();
  var styles = (0, _loading_chart.euiLoadingChartStyles)(euiTheme);
  var barStyles = (0, _loading_chart.euiLoadingChartBarStyles)(euiTheme);
  var classes = (0, _classnames.default)('euiLoadingChart', {
    'euiLoadingChart--mono': mono
  }, className);
  var cssStyles = [styles.euiLoadingChart, styles[size]];

  var cssBarStyles = function cssBarStyles(index) {
    return [barStyles.euiLoadingChart__bar, barStyles[size], (0, _loading_chart._barIndex)(index, mono, euiTheme)];
  };

  var bars = [];

  for (var index = 0; index < 4; index++) {
    bars.push((0, _react2.jsx)("span", {
      key: index,
      css: cssBarStyles(index)
    }));
  }

  return (0, _react2.jsx)("span", (0, _extends2.default)({
    className: classes,
    css: cssStyles,
    role: "progressbar",
    "aria-label": ariaLabel || defaultAriaLabel
  }, rest), bars);
};

exports.EuiLoadingChart = EuiLoadingChart;