"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

var _typeof = require("@babel/runtime/helpers/typeof");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ICON_SIDES = exports.EuiFormControlLayoutIcons = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));

var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));

var _inherits2 = _interopRequireDefault(require("@babel/runtime/helpers/inherits"));

var _possibleConstructorReturn2 = _interopRequireDefault(require("@babel/runtime/helpers/possibleConstructorReturn"));

var _getPrototypeOf2 = _interopRequireDefault(require("@babel/runtime/helpers/getPrototypeOf"));

var _react = _interopRequireWildcard(require("react"));

var _loading = require("../../loading");

var _form_control_layout_clear_button = require("./form_control_layout_clear_button");

var _form_control_layout_custom_icon = require("./form_control_layout_custom_icon");

var _icon = require("../../icon");

var _react2 = require("@emotion/react");

var _excluded = ["ref", "side"];

function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }

function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2.default)(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2.default)(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2.default)(this, result); }; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

var ICON_SIDES = ['left', 'right'];
exports.ICON_SIDES = ICON_SIDES;

function isIconShape(icon) {
  return !!icon && icon.hasOwnProperty('type');
}

var EuiFormControlLayoutIcons = /*#__PURE__*/function (_Component) {
  (0, _inherits2.default)(EuiFormControlLayoutIcons, _Component);

  var _super = _createSuper(EuiFormControlLayoutIcons);

  function EuiFormControlLayoutIcons() {
    (0, _classCallCheck2.default)(this, EuiFormControlLayoutIcons);
    return _super.apply(this, arguments);
  }

  (0, _createClass2.default)(EuiFormControlLayoutIcons, [{
    key: "render",
    value: function render() {
      var _this$props = this.props,
          icon = _this$props.icon,
          isInvalid = _this$props.isInvalid,
          isDropdown = _this$props.isDropdown;
      var iconSide = isIconShape(icon) && icon.side ? icon.side : 'left';
      var customIcon = this.renderCustomIcon();
      var loadingSpinner = this.renderLoadingSpinner();
      var clearButton = this.renderClearButton();
      var invalidIcon = this.renderInvalidIcon();
      var dropdownIcon = this.renderDropdownIcon();
      var leftIcons;

      if (customIcon && iconSide === 'left') {
        leftIcons = (0, _react2.jsx)("div", {
          className: "euiFormControlLayoutIcons"
        }, customIcon);
      }

      var rightIcons; // If the icon is on the right, it should be placed after the clear button in the DOM.

      if (clearButton || loadingSpinner || isInvalid || isDropdown || customIcon && iconSide === 'right') {
        rightIcons = (0, _react2.jsx)("div", {
          className: "euiFormControlLayoutIcons euiFormControlLayoutIcons--right"
        }, clearButton, loadingSpinner, invalidIcon, iconSide === 'right' ? customIcon : undefined, dropdownIcon);
      }

      return (0, _react2.jsx)(_react.Fragment, null, leftIcons, rightIcons);
    }
  }, {
    key: "renderCustomIcon",
    value: function renderCustomIcon() {
      var _this$props2 = this.props,
          icon = _this$props2.icon,
          compressed = _this$props2.compressed;

      if (!icon) {
        return null;
      } // Normalize the icon to an object if it's a string.


      var iconProps = isIconShape(icon) ? icon : {
        type: icon
      };
      var iconRef = iconProps.ref,
          side = iconProps.side,
          iconRest = (0, _objectWithoutProperties2.default)(iconProps, _excluded);
      return (0, _react2.jsx)(_form_control_layout_custom_icon.EuiFormControlLayoutCustomIcon, (0, _extends2.default)({
        size: compressed ? 's' : 'm',
        iconRef: iconRef
      }, iconRest));
    }
  }, {
    key: "renderDropdownIcon",
    value: function renderDropdownIcon() {
      var _this$props3 = this.props,
          isDropdown = _this$props3.isDropdown,
          compressed = _this$props3.compressed;

      if (!isDropdown) {
        return null;
      }

      return (0, _react2.jsx)(_form_control_layout_custom_icon.EuiFormControlLayoutCustomIcon, {
        size: compressed ? 's' : 'm',
        type: "arrowDown"
      });
    }
  }, {
    key: "renderLoadingSpinner",
    value: function renderLoadingSpinner() {
      var _this$props4 = this.props,
          isLoading = _this$props4.isLoading,
          compressed = _this$props4.compressed;

      if (!isLoading) {
        return null;
      }

      return (0, _react2.jsx)(_loading.EuiLoadingSpinner, {
        size: compressed ? 's' : 'm'
      });
    }
  }, {
    key: "renderClearButton",
    value: function renderClearButton() {
      var _this$props5 = this.props,
          clear = _this$props5.clear,
          compressed = _this$props5.compressed;

      if (!clear) {
        return null;
      }

      return (0, _react2.jsx)(_form_control_layout_clear_button.EuiFormControlLayoutClearButton, (0, _extends2.default)({
        size: compressed ? 's' : 'm'
      }, clear));
    }
  }, {
    key: "renderInvalidIcon",
    value: function renderInvalidIcon() {
      var _this$props6 = this.props,
          isInvalid = _this$props6.isInvalid,
          compressed = _this$props6.compressed;

      if (!isInvalid) {
        return null;
      }

      return (0, _react2.jsx)(_icon.EuiIcon, {
        size: compressed ? 's' : 'm',
        color: "danger",
        type: "alert"
      });
    }
  }]);
  return EuiFormControlLayoutIcons;
}(_react.Component);

exports.EuiFormControlLayoutIcons = EuiFormControlLayoutIcons;