"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

var _typeof = require("@babel/runtime/helpers/typeof");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiFocusTrap = void 0;

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));

var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));

var _assertThisInitialized2 = _interopRequireDefault(require("@babel/runtime/helpers/assertThisInitialized"));

var _inherits2 = _interopRequireDefault(require("@babel/runtime/helpers/inherits"));

var _possibleConstructorReturn2 = _interopRequireDefault(require("@babel/runtime/helpers/possibleConstructorReturn"));

var _getPrototypeOf2 = _interopRequireDefault(require("@babel/runtime/helpers/getPrototypeOf"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _react = _interopRequireWildcard(require("react"));

var _reactFocusOn = require("react-focus-on");

var _services = require("../../services");

var _react2 = require("@emotion/react");

var _excluded = ["children", "clickOutsideDisables", "disabled", "returnFocus", "noIsolation", "scrollLock"];

function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }

function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) { symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); } keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { (0, _defineProperty2.default)(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2.default)(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2.default)(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2.default)(this, result); }; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

var EuiFocusTrap = /*#__PURE__*/function (_Component) {
  (0, _inherits2.default)(EuiFocusTrap, _Component);

  var _super = _createSuper(EuiFocusTrap);

  function EuiFocusTrap() {
    var _this;

    (0, _classCallCheck2.default)(this, EuiFocusTrap);

    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    _this = _super.call.apply(_super, [this].concat(args));
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "state", {
      hasBeenDisabledByClick: false
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "lastInterceptedEvent", null);
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "preventFocusExit", false);
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "setInitialFocus", function (initialFocus) {
      var node = (0, _services.findElementBySelectorOrRef)(initialFocus);
      if (!node) return; // `data-autofocus` is part of the 'react-focus-on' API

      node.setAttribute('data-autofocus', 'true');
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "onMouseupOutside", function (e) {
      _this.removeMouseupListener(); // Timeout gives precedence to the consumer to initiate close if it has toggle behavior.
      // Otherwise this event may occur first and the consumer toggle will reopen the flyout.


      setTimeout(function () {
        var _this$props$onClickOu, _this$props;

        return (_this$props$onClickOu = (_this$props = _this.props).onClickOutside) === null || _this$props$onClickOu === void 0 ? void 0 : _this$props$onClickOu.call(_this$props, e);
      });
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "addMouseupListener", function () {
      document.addEventListener('mouseup', _this.onMouseupOutside);
      document.addEventListener('touchend', _this.onMouseupOutside);
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "removeMouseupListener", function () {
      document.removeEventListener('mouseup', _this.onMouseupOutside);
      document.removeEventListener('touchend', _this.onMouseupOutside);
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "handleOutsideClick", function (event) {
      var _this$props2 = _this.props,
          onClickOutside = _this$props2.onClickOutside,
          clickOutsideDisables = _this$props2.clickOutsideDisables,
          closeOnMouseup = _this$props2.closeOnMouseup;

      if (clickOutsideDisables) {
        _this.setState({
          hasBeenDisabledByClick: true
        });
      }

      if (onClickOutside) {
        closeOnMouseup ? _this.addMouseupListener() : onClickOutside(event);
      }
    });
    return _this;
  }

  (0, _createClass2.default)(EuiFocusTrap, [{
    key: "componentDidMount",
    value: function componentDidMount() {
      this.setInitialFocus(this.props.initialFocus);
    }
  }, {
    key: "componentDidUpdate",
    value: function componentDidUpdate(prevProps) {
      if (prevProps.disabled === true && this.props.disabled === false) {
        // eslint-disable-next-line react/no-did-update-set-state
        this.setState({
          hasBeenDisabledByClick: false
        });
      }
    }
  }, {
    key: "componentWillUnmount",
    value: function componentWillUnmount() {
      this.removeMouseupListener();
    } // Programmatically sets focus on a nested DOM node; optional

  }, {
    key: "render",
    value: function render() {
      var _this$props3 = this.props,
          children = _this$props3.children,
          clickOutsideDisables = _this$props3.clickOutsideDisables,
          disabled = _this$props3.disabled,
          returnFocus = _this$props3.returnFocus,
          noIsolation = _this$props3.noIsolation,
          scrollLock = _this$props3.scrollLock,
          rest = (0, _objectWithoutProperties2.default)(_this$props3, _excluded);
      var isDisabled = disabled || this.state.hasBeenDisabledByClick;

      var focusOnProps = _objectSpread(_objectSpread({
        returnFocus: returnFocus,
        noIsolation: noIsolation,
        scrollLock: scrollLock,
        enabled: !isDisabled
      }, rest), {}, {
        onClickOutside: this.handleOutsideClick
      });

      return (0, _react2.jsx)(_reactFocusOn.FocusOn, focusOnProps, children);
    }
  }]);
  return EuiFocusTrap;
}(_react.Component);

exports.EuiFocusTrap = EuiFocusTrap;
(0, _defineProperty2.default)(EuiFocusTrap, "defaultProps", {
  clickOutsideDisables: false,
  disabled: false,
  returnFocus: true,
  noIsolation: true,
  scrollLock: false
});