"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiExpression = exports.COLORS = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _react = _interopRequireDefault(require("react"));

var _classnames = _interopRequireDefault(require("classnames"));

var _icon = require("../icon");

var _services = require("../../services");

var _expression = require("./expression.styles");

var _react2 = require("@emotion/react");

var _excluded = ["className", "description", "descriptionProps", "value", "valueProps", "color", "uppercase", "isActive", "display", "descriptionWidth", "onClick", "isInvalid", "textWrap"];

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) { symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); } keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { (0, _defineProperty2.default)(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

var COLORS = ['subdued', 'primary', 'success', 'accent', 'warning', 'danger'];
exports.COLORS = COLORS;

var EuiExpression = function EuiExpression(_ref) {
  var className = _ref.className,
      description = _ref.description,
      descriptionProps = _ref.descriptionProps,
      value = _ref.value,
      valueProps = _ref.valueProps,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? 'success' : _ref$color,
      _ref$uppercase = _ref.uppercase,
      uppercase = _ref$uppercase === void 0 ? true : _ref$uppercase,
      _ref$isActive = _ref.isActive,
      isActive = _ref$isActive === void 0 ? false : _ref$isActive,
      _ref$display = _ref.display,
      display = _ref$display === void 0 ? 'inline' : _ref$display,
      _ref$descriptionWidth = _ref.descriptionWidth,
      descriptionWidth = _ref$descriptionWidth === void 0 ? '20%' : _ref$descriptionWidth,
      onClick = _ref.onClick,
      _ref$isInvalid = _ref.isInvalid,
      isInvalid = _ref$isInvalid === void 0 ? false : _ref$isInvalid,
      _ref$textWrap = _ref.textWrap,
      textWrap = _ref$textWrap === void 0 ? 'break-word' : _ref$textWrap,
      rest = (0, _objectWithoutProperties2.default)(_ref, _excluded);
  var calculatedColor = isInvalid ? 'danger' : color;
  var theme = (0, _services.useEuiTheme)();
  var styles = (0, _expression.euiExpressionStyles)(theme);
  var cssStyles = [styles.euiExpression, onClick && styles.isClickable, styles[color], isActive && styles.isActive.base, isActive && styles.isActive[color], display === 'columns' && styles.columns, textWrap === 'truncate' && styles.truncate];
  var descriptionStyles = (0, _expression.euiExpressionDescriptionStyles)(theme);
  var cssDescriptionStyles = [descriptionStyles.euiExpression__description, isInvalid ? descriptionStyles.danger : descriptionStyles[color], uppercase && descriptionStyles.isUppercase, textWrap === 'truncate' && descriptionStyles.truncate, display === 'columns' && descriptionStyles.columns];
  var valueStyles = (0, _expression.euiExpressionValueStyles)(theme);
  var cssValueStyles = [valueStyles.euiExpression__value, textWrap === 'truncate' && valueStyles.truncate, display === 'columns' && valueStyles.columns];
  var iconStyles = (0, _expression.euiExpressionIconStyles)(theme);
  var cssIconStyles = [iconStyles.euiExpression__icon, display === 'columns' && iconStyles.columns];
  var classes = (0, _classnames.default)('euiExpression', className);
  var Component = onClick ? 'button' : 'span';
  var descriptionStyle = descriptionProps && descriptionProps.style;
  var customWidth = display === 'columns' && descriptionWidth ? _objectSpread({
    flexBasis: descriptionWidth
  }, descriptionStyle) : undefined;
  var invalidIcon = isInvalid ? (0, _react2.jsx)(_icon.EuiIcon, {
    className: "euiExpression__icon",
    type: "alert",
    css: cssIconStyles,
    color: calculatedColor
  }) : undefined;
  return (0, _react2.jsx)(Component, (0, _extends2.default)({
    css: cssStyles,
    className: classes,
    onClick: onClick
  }, rest), (0, _react2.jsx)("span", (0, _extends2.default)({
    className: "euiExpression__description",
    css: cssDescriptionStyles,
    style: customWidth
  }, descriptionProps), description), ' ', value && (0, _react2.jsx)("span", (0, _extends2.default)({
    className: "euiExpression__value",
    css: cssValueStyles
  }, valueProps), value), invalidIcon);
};

exports.EuiExpression = EuiExpression;