"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useVirtualizeContainerWidth = exports.useUnconstrainedHeight = exports.useFinalGridDimensions = void 0;

var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));

var _react = require("react");

var _utils = require("../../../utils");

var _services = require("../../../services");

var _resize_observer = require("../../observer/resize_observer");

var _sorting = require("./sorting");

/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
var useFinalGridDimensions = function useFinalGridDimensions(_ref) {
  var unconstrainedHeight = _ref.unconstrainedHeight,
      unconstrainedWidth = _ref.unconstrainedWidth,
      wrapperDimensions = _ref.wrapperDimensions,
      wrapperRef = _ref.wrapperRef,
      isFullScreen = _ref.isFullScreen,
      rowCount = _ref.rowCount;

  // Used if the grid needs to scroll
  var _useState = (0, _react.useState)(undefined),
      _useState2 = (0, _slicedToArray2.default)(_useState, 2),
      height = _useState2[0],
      setHeight = _useState2[1];

  var _useState3 = (0, _react.useState)(undefined),
      _useState4 = (0, _slicedToArray2.default)(_useState3, 2),
      width = _useState4[0],
      setWidth = _useState4[1]; // Tracking fullscreen height separately is necessary to correctly restore the grid back to non-fullscreen height


  var _useState5 = (0, _react.useState)(0),
      _useState6 = (0, _slicedToArray2.default)(_useState5, 2),
      fullScreenHeight = _useState6[0],
      setFullScreenHeight = _useState6[1]; // Set the wrapper height on load, whenever the grid wrapper resizes, and whenever rowCount changes


  (0, _react.useEffect)(function () {
    var boundingRect = wrapperRef.current.getBoundingClientRect();

    if (isFullScreen) {
      setFullScreenHeight(boundingRect.height);
    } else {
      if (boundingRect.height !== unconstrainedHeight) {
        setHeight(boundingRect.height);
      }
    }

    if (boundingRect.width !== unconstrainedWidth) {
      setWidth(boundingRect.width);
    }
  }, [// Effects that should cause recalculations
  rowCount, isFullScreen, wrapperDimensions, // Dependencies
  wrapperRef, unconstrainedHeight, unconstrainedWidth]);
  var finalHeight = isFullScreen ? fullScreenHeight : height || unconstrainedHeight;
  var finalWidth = width || unconstrainedWidth;
  return _utils.IS_JEST_ENVIRONMENT ? {
    finalHeight: Number.MAX_SAFE_INTEGER,
    finalWidth: Number.MAX_SAFE_INTEGER
  } : {
    finalHeight: finalHeight,
    finalWidth: finalWidth
  };
};
/**
 * Computes the unconstrained (total possible) height of a grid
 */


exports.useFinalGridDimensions = useFinalGridDimensions;

var useUnconstrainedHeight = function useUnconstrainedHeight(_ref2) {
  var rowHeightUtils = _ref2.rowHeightUtils,
      startRow = _ref2.startRow,
      endRow = _ref2.endRow,
      rowHeightsOptions = _ref2.rowHeightsOptions,
      defaultRowHeight = _ref2.defaultRowHeight,
      headerRowHeight = _ref2.headerRowHeight,
      footerRowHeight = _ref2.footerRowHeight,
      scrollBarHeight = _ref2.scrollBarHeight,
      innerGridRef = _ref2.innerGridRef;

  var _useContext = (0, _react.useContext)(_sorting.DataGridSortingContext),
      getCorrectRowIndex = _useContext.getCorrectRowIndex;

  var knownHeight = 0; // tracks the pixel height of rows we know the size of

  var knownRowCount = 0; // how many rows we know the size of

  for (var i = startRow; i < endRow; i++) {
    var correctRowIndex = getCorrectRowIndex(i); // map visible row to logical row
    // lookup the height configuration of this row

    var rowHeightOption = rowHeightUtils.getRowHeightOption(correctRowIndex, rowHeightsOptions);

    if (rowHeightOption) {
      // this row's height is known
      knownRowCount++;
      knownHeight += rowHeightUtils.getCalculatedHeight(rowHeightOption, defaultRowHeight, correctRowIndex, rowHeightUtils.isRowHeightOverride(correctRowIndex, rowHeightsOptions));
    }
  } // how many rows to provide space for on the screen


  var rowCountToAffordFor = endRow - startRow; // watch the inner element for a change to its width
  // which may cause the horizontal scrollbar to be added or removed

  var _useResizeObserver = (0, _resize_observer.useResizeObserver)(innerGridRef.current, 'width'),
      innerWidth = _useResizeObserver.width;

  var forceRender = (0, _services.useForceRender)();
  (0, _services.useUpdateEffect)(forceRender, [innerWidth]);
  var unconstrainedHeight = defaultRowHeight * (rowCountToAffordFor - knownRowCount) + // guess how much space is required for unknown rows
  knownHeight + // computed pixel height of the known rows
  headerRowHeight + // account for header
  footerRowHeight + // account for footer
  scrollBarHeight; // account for horizontal scrollbar

  return unconstrainedHeight;
};
/**
 * Returns the size of the cell container minus the scroll bar width.
 * To do so, this hook is listening for size changes of the container itself,
 * as well as pagination changes to make sure every update is caught.
 *
 * This is necessary because there is no callback/event fired by the browser
 * indicating the scroll bar state has changed.
 * @param resizeRef the wrapper element containging the data grid
 * @param pageSize the currently applied page size
 */


exports.useUnconstrainedHeight = useUnconstrainedHeight;

var useVirtualizeContainerWidth = function useVirtualizeContainerWidth(virtualizeContainer, gridWidth, pageSize) {
  var _useState7 = (0, _react.useState)(0),
      _useState8 = (0, _slicedToArray2.default)(_useState7, 2),
      virtualizeContainerWidth = _useState8[0],
      setVirtualizeContainerWidth = _useState8[1];

  (0, _resize_observer.useResizeObserver)(virtualizeContainer); // re-render data grid on size changes

  var forceRender = (0, _services.useForceRender)();
  (0, _services.useUpdateEffect)(forceRender, [gridWidth, forceRender]);
  (0, _react.useEffect)(function () {
    if (virtualizeContainer !== null && virtualizeContainer !== void 0 && virtualizeContainer.clientWidth) {
      setVirtualizeContainerWidth(virtualizeContainer.clientWidth);
    }
  }, [virtualizeContainer === null || virtualizeContainer === void 0 ? void 0 : virtualizeContainer.clientWidth]);
  (0, _react.useEffect)(function () {
    // wait for layout to settle, then measure virtualize container
    setTimeout(function () {
      if (virtualizeContainer !== null && virtualizeContainer !== void 0 && virtualizeContainer.clientWidth) {
        var containerWidth = virtualizeContainer.clientWidth;
        setVirtualizeContainerWidth(containerWidth);
      }
    }, 100);
  }, [pageSize, virtualizeContainer]); // Use clientWidth of the virtualization container to take scroll bar into account
  // If that's not possible, fall back to the width of the wrapper element

  return virtualizeContainerWidth || gridWidth;
};

exports.useVirtualizeContainerWidth = useVirtualizeContainerWidth;