"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

var _typeof = require("@babel/runtime/helpers/typeof");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiButtonDisplay = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _react = _interopRequireWildcard(require("react"));

var _react2 = require("@emotion/react");

var _services = require("../../../services");

var _button_display = require("./_button_display.styles");

var _button_display_content = require("./_button_display_content");

var _excluded = ["element", "children", "iconType", "iconSide", "size", "isDisabled", "isLoading", "isSelected", "fullWidth", "minWidth", "contentProps", "textProps"];

function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }

function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) { symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); } keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { (0, _defineProperty2.default)(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

/**
 * EuiButtonDisplay is an internal-only component used for displaying
 * any element as a button.
 */
var EuiButtonDisplay = /*#__PURE__*/(0, _react.forwardRef)(function (_ref, ref) {
  var _ref$element = _ref.element,
      element = _ref$element === void 0 ? 'button' : _ref$element,
      children = _ref.children,
      iconType = _ref.iconType,
      iconSide = _ref.iconSide,
      _ref$size = _ref.size,
      size = _ref$size === void 0 ? 'm' : _ref$size,
      _ref$isDisabled = _ref.isDisabled,
      isDisabled = _ref$isDisabled === void 0 ? false : _ref$isDisabled,
      isLoading = _ref.isLoading,
      isSelected = _ref.isSelected,
      fullWidth = _ref.fullWidth,
      minWidth = _ref.minWidth,
      contentProps = _ref.contentProps,
      textProps = _ref.textProps,
      rest = (0, _objectWithoutProperties2.default)(_ref, _excluded);
  var buttonIsDisabled = isLoading || isDisabled;
  var minWidthPx = minWidth === 'number' ? "".concat(minWidth, "px") : minWidth;
  var theme = (0, _services.useEuiTheme)();
  var styles = (0, _button_display.euiButtonDisplayStyles)(theme, minWidthPx);
  var cssStyles = [styles.euiButtonDisplay, styles[size], fullWidth && styles.fullWidth, isDisabled && styles.isDisabled];
  var innerNode = (0, _react2.jsx)(_button_display_content.EuiButtonDisplayContent, (0, _extends2.default)({
    isLoading: isLoading,
    isDisabled: buttonIsDisabled,
    iconType: iconType,
    iconSide: iconSide,
    textProps: _objectSpread({}, textProps)
  }, contentProps), children);
  return (0, _react2.createElement)(element, _objectSpread({
    css: cssStyles,
    disabled: element === 'button' && buttonIsDisabled,
    'aria-pressed': element === 'button' ? isSelected : undefined,
    ref: ref
  }, rest), innerNode);
});
exports.EuiButtonDisplay = EuiButtonDisplay;
EuiButtonDisplay.displayName = 'EuiButtonDisplay';