import _defineProperty from "@babel/runtime/helpers/defineProperty";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
var _excluded = ["children", "textAlign", "cloneElement"];

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) { symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); } keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
import React, { isValidElement } from 'react';
import { cloneElementWithCss } from '../../services/theme/clone_element';
import { euiTextAlignStyles } from './text_align.styles';
import { jsx as ___EmotionJSX } from "@emotion/react";
export var ALIGNMENTS = ['left', 'right', 'center'];
export var EuiTextAlign = function EuiTextAlign(_ref) {
  var children = _ref.children,
      _ref$textAlign = _ref.textAlign,
      textAlign = _ref$textAlign === void 0 ? 'left' : _ref$textAlign,
      _ref$cloneElement = _ref.cloneElement,
      cloneElement = _ref$cloneElement === void 0 ? false : _ref$cloneElement,
      rest = _objectWithoutProperties(_ref, _excluded);

  var styles = euiTextAlignStyles();
  var cssStyles = [styles.euiTextAlign, styles[textAlign]];

  var props = _objectSpread({
    css: cssStyles
  }, rest);

  if ( /*#__PURE__*/isValidElement(children) && cloneElement) {
    return cloneElementWithCss(children, props);
  } else {
    return ___EmotionJSX("div", props, children);
  }
};