import _taggedTemplateLiteral from "@babel/runtime/helpers/taggedTemplateLiteral";

var _templateObject;

function _EMOTION_STRINGIFIED_CSS_ERROR__() { return "You have tried to stringify object returned from `css` function. It isn't supposed to be used directly (e.g. as value of the `className` prop), but rather handed to emotion so it can handle it (e.g. as value of `css` prop)."; }

/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
import { css, keyframes } from '@emotion/react';
import { logicalCSS, logicalTextAlignCSS, euiCantAnimate, euiFontSize, euiTextTruncate } from '../../global_styling';
import { euiPaletteColorBlind, makeHighContrastColor } from '../../services';
import { euiText } from '../text/text.styles';
/**
 * DRY utilities for native/determinate progress components vs non-native indeterminate
 */

var crossBrowserProgressValue = function crossBrowserProgressValue(cssProperties) {
  return "\n  &::-webkit-progress-value {\n    ".concat(cssProperties, "\n  }\n  &::-moz-progress-bar {\n    ").concat(cssProperties, "\n  }\n");
};

var indeterminateProgressValue = function indeterminateProgressValue(cssProperties) {
  return "\n  &:before {\n    ".concat(cssProperties, "\n  }\n");
};
/**
 * Color utilities
 */


var visColors = euiPaletteColorBlind();

var nativeVsIndeterminateColor = function nativeVsIndeterminateColor(color, isNative) {
  var selectors = isNative ? crossBrowserProgressValue : indeterminateProgressValue;
  return selectors("background-color: ".concat(color, ";"));
};
/**
 * DRY utils for non-static positions
 */


var nonStaticPositioning = function nonStaticPositioning(isNative) {
  return "\n  top: 0;\n  left: 0;\n  right: 0;\n  background-color: transparent;\n  ".concat(isNative ? "\n      &::-webkit-progress-bar {\n        background-color: transparent;\n      }" : '', "\n");
};
/**
 * Animations
 */


var euiIndeterminateAnimation = keyframes(_templateObject || (_templateObject = _taggedTemplateLiteral(["\n  0% {\n    transform: scaleX(1) translateX(-100%);\n  }\n  100% {\n    transform: scaleX(1) translateX(100%);\n  }\n"])));
/**
 * Emotion styles
 */

var _ref2 = process.env.NODE_ENV === "production" ? {
  name: "187h6sp-static",
  styles: "position:relative;label:static;"
} : {
  name: "187h6sp-static",
  styles: "position:relative;label:static;",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};

export var euiProgressStyles = function euiProgressStyles(_ref3, isNative) {
  var euiTheme = _ref3.euiTheme;
  return {
    euiProgress: /*#__PURE__*/css("overflow:hidden;background-color:", euiTheme.colors.lightShade, ";;label:euiProgress;"),
    // https://css-tricks.com/html5-progress-element/
    // Good resource if you need to work in here. There's some gotchas with
    // dealing with cross-browser progress bars.
    native: /*#__PURE__*/css("display:block;", logicalCSS('width', '100%'), " appearance:none;border:none;border-radius:", euiTheme.size.s, ";&::-webkit-progress-bar{background-color:", euiTheme.colors.lightShade, ";}", crossBrowserProgressValue("transition: width ".concat(euiTheme.animation.normal, " linear;")), ";;label:native;"),
    // An indeterminate bar has an unreliable end time. Because of a Firefox animation issue,
    // we apply this style to a <div> instead of a <progress> element.
    // See https://css-tricks.com/html5-progress-element/ for more info.
    indeterminate: /*#__PURE__*/css("&:before{position:absolute;content:'';", logicalCSS('width', '100%'), " top:0;bottom:0;left:0;transform:scaleX(0) translateX(0%);animation:", euiIndeterminateAnimation, " 1s ", euiTheme.animation.resistance, " infinite;", euiCantAnimate, "{animation-duration:2s;animation-timing-function:linear;}};label:indeterminate;"),
    // Sizes
    xs: /*#__PURE__*/css(logicalCSS('height', euiTheme.size.xxs), ";;label:xs;"),
    s: /*#__PURE__*/css(logicalCSS('height', euiTheme.size.xs), ";;label:s;"),
    m: /*#__PURE__*/css(logicalCSS('height', euiTheme.size.s), ";;label:m;"),
    l: /*#__PURE__*/css(logicalCSS('height', euiTheme.size.m), ";;label:l;"),
    // Positioning
    fixed: /*#__PURE__*/css("position:fixed;z-index:", Number(euiTheme.levels.header) + 1, ";", nonStaticPositioning(isNative), ";;label:fixed;"),
    absolute: /*#__PURE__*/css("position:absolute;", nonStaticPositioning(isNative), ";;label:absolute;"),
    static: _ref2,
    // Colors
    primary: /*#__PURE__*/css(nativeVsIndeterminateColor(euiTheme.colors.primary, isNative), ";;label:primary;"),
    success: /*#__PURE__*/css(nativeVsIndeterminateColor(euiTheme.colors.success, isNative), ";;label:success;"),
    warning: /*#__PURE__*/css(nativeVsIndeterminateColor(euiTheme.colors.warning, isNative), ";;label:warning;"),
    danger: /*#__PURE__*/css(nativeVsIndeterminateColor(euiTheme.colors.danger, isNative), ";;label:danger;"),
    subdued: /*#__PURE__*/css(nativeVsIndeterminateColor(euiTheme.colors.subduedText, isNative), ";;label:subdued;"),
    accent: /*#__PURE__*/css(nativeVsIndeterminateColor(euiTheme.colors.accent, isNative), ";;label:accent;"),
    vis0: /*#__PURE__*/css(nativeVsIndeterminateColor(visColors[0], isNative), ";;label:vis0;"),
    vis1: /*#__PURE__*/css(nativeVsIndeterminateColor(visColors[1], isNative), ";;label:vis1;"),
    vis2: /*#__PURE__*/css(nativeVsIndeterminateColor(visColors[2], isNative), ";;label:vis2;"),
    vis3: /*#__PURE__*/css(nativeVsIndeterminateColor(visColors[3], isNative), ";;label:vis3;"),
    vis4: /*#__PURE__*/css(nativeVsIndeterminateColor(visColors[4], isNative), ";;label:vis4;"),
    vis5: /*#__PURE__*/css(nativeVsIndeterminateColor(visColors[5], isNative), ";;label:vis5;"),
    vis6: /*#__PURE__*/css(nativeVsIndeterminateColor(visColors[6], isNative), ";;label:vis6;"),
    vis7: /*#__PURE__*/css(nativeVsIndeterminateColor(visColors[7], isNative), ";;label:vis7;"),
    vis8: /*#__PURE__*/css(nativeVsIndeterminateColor(visColors[8], isNative), ";;label:vis8;"),
    vis9: /*#__PURE__*/css(nativeVsIndeterminateColor(visColors[9], isNative), ";;label:vis9;"),
    customColor: /*#__PURE__*/css(nativeVsIndeterminateColor('currentColor', isNative), ";;label:customColor;")
  };
};
/**
 * Data styles
 */

export var euiProgressDataStyles = function euiProgressDataStyles(euiThemeContext) {
  return {
    euiProgress__data: /*#__PURE__*/css("display:flex;justify-content:space-between;gap:", euiThemeContext.euiTheme.size.xs, ";", euiText(euiThemeContext.euiTheme), " ", euiFontSize(euiThemeContext, 'xs'), ";;label:euiProgress__data;"),
    // Sizes
    l: /*#__PURE__*/css(euiFontSize(euiThemeContext, 's'), ";;label:l;")
  };
};
export var euiProgressLabelStyles = {
  euiProgress__label: /*#__PURE__*/css("flex-grow:1;", euiTextTruncate(), ";;label:euiProgress__label;")
};

var _ref = process.env.NODE_ENV === "production" ? {
  name: "15ioh86-customColor",
  styles: "color:currentColor;label:customColor;"
} : {
  name: "15ioh86-customColor",
  styles: "color:currentColor;label:customColor;",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};

export var euiProgressValueTextStyles = function euiProgressValueTextStyles(_ref4) {
  var euiTheme = _ref4.euiTheme;
  return {
    euiProgress__valueText: /*#__PURE__*/css("flex-grow:1;flex-shrink:0;font-feature-settings:'tnum' 1;", logicalTextAlignCSS('right'), " ", euiTextTruncate(), ";;label:euiProgress__valueText;"),
    // Colors
    primary: /*#__PURE__*/css("color:", euiTheme.colors.primaryText, ";;label:primary;"),
    success: /*#__PURE__*/css("color:", euiTheme.colors.successText, ";;label:success;"),
    warning: /*#__PURE__*/css("color:", euiTheme.colors.warningText, ";;label:warning;"),
    danger: /*#__PURE__*/css("color:", euiTheme.colors.dangerText, ";;label:danger;"),
    subdued: /*#__PURE__*/css("color:", euiTheme.colors.subduedText, ";;label:subdued;"),
    accent: /*#__PURE__*/css("color:", euiTheme.colors.accentText, ";;label:accent;"),
    vis0: /*#__PURE__*/css("color:", makeHighContrastColor(visColors[0])(euiTheme), ";;label:vis0;"),
    vis1: /*#__PURE__*/css("color:", makeHighContrastColor(visColors[1])(euiTheme), ";;label:vis1;"),
    vis2: /*#__PURE__*/css("color:", makeHighContrastColor(visColors[2])(euiTheme), ";;label:vis2;"),
    vis3: /*#__PURE__*/css("color:", makeHighContrastColor(visColors[3])(euiTheme), ";;label:vis3;"),
    vis4: /*#__PURE__*/css("color:", makeHighContrastColor(visColors[4])(euiTheme), ";;label:vis4;"),
    vis5: /*#__PURE__*/css("color:", makeHighContrastColor(visColors[5])(euiTheme), ";;label:vis5;"),
    vis6: /*#__PURE__*/css("color:", makeHighContrastColor(visColors[6])(euiTheme), ";;label:vis6;"),
    vis7: /*#__PURE__*/css("color:", makeHighContrastColor(visColors[7])(euiTheme), ";;label:vis7;"),
    vis8: /*#__PURE__*/css("color:", makeHighContrastColor(visColors[8])(euiTheme), ";;label:vis8;"),
    vis9: /*#__PURE__*/css("color:", makeHighContrastColor(visColors[9])(euiTheme), ";;label:vis9;"),
    customColor: _ref
  };
};