import _extends from "@babel/runtime/helpers/extends";

/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
import React, { useContext, forwardRef } from 'react';
import { EuiButtonEmpty, EuiButtonIcon } from '../button';
import { EuiI18n } from '../i18n';
import { EuiToolTip } from '../tool_tip';
import { MODE_VIEWING } from './markdown_modes';
import { EuiMarkdownContext } from './markdown_context';
import { jsx as ___EmotionJSX } from "@emotion/react";
var boldItalicButtons = [{
  id: 'mdBold',
  label: 'Bold',
  name: 'strong',
  iconType: 'editorBold'
}, {
  id: 'mdItalic',
  label: 'Italic',
  name: 'emphasis',
  iconType: 'editorItalic'
}];
var listButtons = [{
  id: 'mdUl',
  label: 'Unordered list',
  name: 'ul',
  iconType: 'editorUnorderedList'
}, {
  id: 'mdOl',
  label: 'Ordered list',
  name: 'ol',
  iconType: 'editorOrderedList'
}, {
  id: 'mdTl',
  label: 'Task list',
  name: 'tl',
  iconType: 'editorChecklist'
}];
var quoteCodeLinkButtons = [{
  id: 'mdQuote',
  label: 'Quote',
  name: 'quote',
  iconType: 'quote'
}, {
  id: 'mdCode',
  label: 'Code',
  name: 'inlineCode',
  iconType: 'editorCodeBlock'
}, {
  id: 'mdLink',
  label: 'Link',
  name: 'link',
  iconType: 'editorLink'
}];

var EuiMarkdownEditorToolbarButton = function EuiMarkdownEditorToolbarButton(_ref) {
  var selectedNode = _ref.selectedNode,
      handleMdButtonClick = _ref.handleMdButtonClick,
      isEditable = _ref.isEditable,
      id = _ref.id,
      nodeId = _ref.nodeId,
      label = _ref.label,
      icon = _ref.icon;
  var isSelected = selectedNode && selectedNode.type === nodeId;
  return ___EmotionJSX(EuiButtonIcon, _extends({
    color: "text"
  }, isSelected ? {
    style: {
      background: 'rgba(0, 0, 0, 0.15)'
    }
  } : null, {
    "data-test-subj": "euiMarkdownEditorToolbarButton".concat(isSelected ? ' pressed' : ''),
    onClick: function onClick() {
      return handleMdButtonClick(id);
    },
    iconType: icon,
    "aria-label": label,
    isDisabled: !isEditable
  }));
};

export var EuiMarkdownEditorToolbar = /*#__PURE__*/forwardRef(function (_ref2, ref) {
  var markdownActions = _ref2.markdownActions,
      viewMode = _ref2.viewMode,
      onClickPreview = _ref2.onClickPreview,
      uiPlugins = _ref2.uiPlugins,
      selectedNode = _ref2.selectedNode;

  var _useContext = useContext(EuiMarkdownContext),
      openPluginEditor = _useContext.openPluginEditor,
      readOnly = _useContext.readOnly;

  var handleMdButtonClick = function handleMdButtonClick(mdButtonId) {
    var actionResult = markdownActions.do(mdButtonId);
    if (actionResult !== true) openPluginEditor(actionResult);
  };

  var isPreviewing = viewMode === MODE_VIEWING;
  var isEditable = !isPreviewing && !readOnly;
  return ___EmotionJSX("div", {
    ref: ref,
    "data-test-subj": "euiMarkdownEditorToolbar",
    className: "euiMarkdownEditorToolbar"
  }, ___EmotionJSX("div", {
    className: "euiMarkdownEditorToolbar__buttons"
  }, boldItalicButtons.map(function (item) {
    return ___EmotionJSX(EuiToolTip, {
      key: item.id,
      content: item.label,
      delay: "long"
    }, ___EmotionJSX(EuiMarkdownEditorToolbarButton, {
      selectedNode: selectedNode,
      handleMdButtonClick: handleMdButtonClick,
      isEditable: isEditable,
      id: item.id,
      nodeId: item.name,
      label: item.label,
      icon: item.iconType
    }));
  }), ___EmotionJSX("span", {
    className: "euiMarkdownEditorToolbar__divider"
  }), listButtons.map(function (item) {
    return ___EmotionJSX(EuiToolTip, {
      key: item.id,
      content: item.label,
      delay: "long"
    }, ___EmotionJSX(EuiMarkdownEditorToolbarButton, {
      selectedNode: selectedNode,
      handleMdButtonClick: handleMdButtonClick,
      isEditable: isEditable,
      id: item.id,
      nodeId: item.name,
      label: item.label,
      icon: item.iconType
    }));
  }), ___EmotionJSX("span", {
    className: "euiMarkdownEditorToolbar__divider"
  }), quoteCodeLinkButtons.map(function (item) {
    return ___EmotionJSX(EuiToolTip, {
      key: item.id,
      content: item.label,
      delay: "long"
    }, ___EmotionJSX(EuiMarkdownEditorToolbarButton, {
      selectedNode: selectedNode,
      handleMdButtonClick: handleMdButtonClick,
      isEditable: isEditable,
      id: item.id,
      nodeId: item.name,
      label: item.label,
      icon: item.iconType
    }));
  }), uiPlugins.length > 0 ? ___EmotionJSX(React.Fragment, null, ___EmotionJSX("span", {
    className: "euiMarkdownEditorToolbar__divider"
  }), uiPlugins.map(function (_ref3) {
    var name = _ref3.name,
        button = _ref3.button;
    return ___EmotionJSX(EuiToolTip, {
      key: name,
      content: button.label,
      delay: "long"
    }, ___EmotionJSX(EuiMarkdownEditorToolbarButton, {
      selectedNode: selectedNode,
      handleMdButtonClick: handleMdButtonClick,
      isEditable: isEditable,
      id: name,
      nodeId: name,
      label: button.label,
      icon: button.iconType
    }));
  })) : null), isPreviewing ? ___EmotionJSX(EuiButtonEmpty, {
    iconType: "editorCodeBlock",
    color: "text",
    size: "s",
    onClick: onClickPreview,
    isDisabled: readOnly
  }, ___EmotionJSX(EuiI18n, {
    token: "euiMarkdownEditorToolbar.editor",
    default: "Editor"
  })) : ___EmotionJSX(EuiButtonEmpty, {
    iconType: "eye",
    color: "text",
    size: "s",
    onClick: onClickPreview,
    isDisabled: readOnly
  }, ___EmotionJSX(EuiI18n, {
    token: "euiMarkdownEditorToolbar.previewMarkdown",
    default: "Preview"
  })));
});
EuiMarkdownEditorToolbar.displayName = 'EuiMarkdownEditorToolbar';