/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
import { css } from '@emotion/react';
import { transparentize } from '../../services';
import { euiScreenReaderOnly } from '../accessibility';
export var euiMarkStyles = function euiMarkStyles(_ref, _ref2) {
  var euiTheme = _ref.euiTheme,
      colorMode = _ref.colorMode;
  var hasScreenReaderHelpText = _ref2.hasScreenReaderHelpText,
      highlightStart = _ref2.highlightStart,
      highlightEnd = _ref2.highlightEnd;
  // TODO: Was $euiFocusBackgroundColor
  var transparency = {
    LIGHT: 0.1,
    DARK: 0.3
  };
  return /*#__PURE__*/css("background-color:", transparentize(euiTheme.colors.primary, transparency[colorMode]), ";font-weight:", euiTheme.font.weight.bold, ";color:", euiTheme.colors.text, ";", hasScreenReaderHelpText === true && "\n      &:before,\n      &:after {\n        ".concat(euiScreenReaderOnly(), "\n      }\n\n      &:before {\n        content: ' [").concat(highlightStart, "] ';\n      }\n\n      &:after {\n        content: ' [").concat(highlightEnd, "] ';\n      }\n    "), ";;label:euiMarkStyles;");
};