import _extends from "@babel/runtime/helpers/extends";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
var _excluded = ["size", "logo", "aria-label", "className"];

/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
import React from 'react';
import classNames from 'classnames';
import { EuiIcon } from '../icon';
import { useEuiTheme } from '../../services';
import { useLoadingAriaLabel } from './_loading_strings';
import { euiLoadingLogoStyles, euiLoadingLogoIconStyles } from './loading_logo.styles';
import { jsx as ___EmotionJSX } from "@emotion/react";
export var SIZES = ['m', 'l', 'xl'];
export var EuiLoadingLogo = function EuiLoadingLogo(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 'm' : _ref$size,
      _ref$logo = _ref.logo,
      logo = _ref$logo === void 0 ? 'logoKibana' : _ref$logo,
      ariaLabel = _ref['aria-label'],
      className = _ref.className,
      rest = _objectWithoutProperties(_ref, _excluded);

  var euiTheme = useEuiTheme();
  var defaultLabel = useLoadingAriaLabel();
  var styles = euiLoadingLogoStyles(euiTheme);
  var cssStyles = [styles.euiLoadingLogo, styles[size]];
  var iconStyles = euiLoadingLogoIconStyles(euiTheme);
  var iconCssStyles = [iconStyles.euiLoadingLogo__icon];
  var classes = classNames('euiLoadingLogo', className);
  return ___EmotionJSX("span", _extends({
    className: classes,
    css: cssStyles,
    role: "progressbar",
    "aria-label": ariaLabel || defaultLabel
  }, rest), ___EmotionJSX("span", {
    css: iconCssStyles
  }, ___EmotionJSX(EuiIcon, {
    type: logo,
    size: size
  })));
};