import _taggedTemplateLiteral from "@babel/runtime/helpers/taggedTemplateLiteral";

var _templateObject;

function _EMOTION_STRINGIFIED_CSS_ERROR__() { return "You have tried to stringify object returned from `css` function. It isn't supposed to be used directly (e.g. as value of the `className` prop), but rather handed to emotion so it can handle it (e.g. as value of `css` prop)."; }

/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
import { css, keyframes } from '@emotion/react';
import { euiPaletteColorBlind, shadeOrTint } from '../../services';
import { euiCanAnimate, logicalCSS } from '../../global_styling';

var _ref2 = process.env.NODE_ENV === "production" ? {
  name: "yovxj7-euiLoadingChart",
  styles: "overflow:hidden;display:inline-flex;label:euiLoadingChart;"
} : {
  name: "yovxj7-euiLoadingChart",
  styles: "overflow:hidden;display:inline-flex;label:euiLoadingChart;",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};

export var euiLoadingChartStyles = function euiLoadingChartStyles(_ref3) {
  var euiTheme = _ref3.euiTheme;
  return {
    euiLoadingChart: _ref2,
    m: /*#__PURE__*/css("height:", euiTheme.size.base, ";gap:", euiTheme.size.xxs, ";;label:m;"),
    l: /*#__PURE__*/css("height:", euiTheme.size.l, ";gap:", euiTheme.size.xxs, ";;label:l;"),
    xl: /*#__PURE__*/css("height:", euiTheme.size.xl, ";gap:", euiTheme.size.xs, ";;label:xl;")
  };
};

var _ref = process.env.NODE_ENV === "production" ? {
  name: "decz5u-euiLoadingChart__bar",
  styles: "height:100%;display:inline-block;label:euiLoadingChart__bar;"
} : {
  name: "decz5u-euiLoadingChart__bar",
  styles: "height:100%;display:inline-block;label:euiLoadingChart__bar;",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};

export var euiLoadingChartBarStyles = function euiLoadingChartBarStyles(_ref4) {
  var euiTheme = _ref4.euiTheme;
  return {
    euiLoadingChart__bar: _ref,
    m: /*#__PURE__*/css("width:", euiTheme.size.xxs, ";", logicalCSS('margin-bottom', euiTheme.size.s), ";;label:m;"),
    l: /*#__PURE__*/css("width:", euiTheme.size.xs, ";", logicalCSS('margin-bottom', euiTheme.size.m), ";;label:l;"),
    xl: /*#__PURE__*/css("width:", euiTheme.size.s, ";", logicalCSS('margin-bottom', euiTheme.size.base), ";;label:xl;")
  };
};
var barAnimation = keyframes(_templateObject || (_templateObject = _taggedTemplateLiteral(["\n  0% {\n    transform: translateY(0);\n  }\n\n  50% {\n    transform: translateY(66%);\n  }\n\n  100% {\n    transform: translateY(0);\n  }\n"])));
export var _barIndex = function _barIndex(index, mono, _ref5) {
  var euiTheme = _ref5.euiTheme,
      colorMode = _ref5.colorMode;
  var backgroundColor = mono ? shadeOrTint(euiTheme.colors.lightShade, index * 0.04, colorMode) : euiPaletteColorBlind()[index];
  return /*#__PURE__*/css("background-color:", backgroundColor, ";transform:translateY(", 22 * index, "%);", euiCanAnimate, "{animation:", barAnimation, " 1s ", ".".concat(index, "s"), " infinite;}");
};