import _extends from "@babel/runtime/helpers/extends";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
var _excluded = ["children", "className", "gutterSize", "fullWidth", "ratio", "titleSize", "title", "description", "descriptionFlexItemProps", "fieldFlexItemProps"];

/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
import React from 'react';
import classNames from 'classnames';
import { EuiTitle } from '../../title';
import { EuiText } from '../../text';
import { EuiFlexGroup, EuiFlexItem } from '../../flex';
import { jsx as ___EmotionJSX } from "@emotion/react";
export var EuiDescribedFormGroup = function EuiDescribedFormGroup(_ref) {
  var children = _ref.children,
      className = _ref.className,
      _ref$gutterSize = _ref.gutterSize,
      gutterSize = _ref$gutterSize === void 0 ? 'l' : _ref$gutterSize,
      _ref$fullWidth = _ref.fullWidth,
      fullWidth = _ref$fullWidth === void 0 ? false : _ref$fullWidth,
      _ref$ratio = _ref.ratio,
      ratio = _ref$ratio === void 0 ? 'half' : _ref$ratio,
      _ref$titleSize = _ref.titleSize,
      titleSize = _ref$titleSize === void 0 ? 'xs' : _ref$titleSize,
      title = _ref.title,
      description = _ref.description,
      descriptionFlexItemProps = _ref.descriptionFlexItemProps,
      fieldFlexItemProps = _ref.fieldFlexItemProps,
      rest = _objectWithoutProperties(_ref, _excluded);

  var classes = classNames('euiDescribedFormGroup', {
    'euiDescribedFormGroup--fullWidth': fullWidth
  }, className);
  var fieldClasses = classNames('euiDescribedFormGroup__fields', fieldFlexItemProps && fieldFlexItemProps.className);
  var renderedDescription;

  if (description) {
    // If the description is just a string, wrap it in a paragraph element
    if (typeof description === 'string') {
      description = ___EmotionJSX("p", null, description);
    }

    renderedDescription = ___EmotionJSX(EuiText, {
      size: "s",
      color: "subdued",
      className: "euiDescribedFormGroup__description"
    }, description);
  }

  var fieldGrowth;

  switch (ratio) {
    case 'half':
      fieldGrowth = 1;
      break;

    case 'third':
      fieldGrowth = 2;
      break;

    case 'quarter':
      fieldGrowth = 3;
      break;

    default:
      console.warn('Please provide an allowed ratio to EuiDescribedFromRow');
      break;
  }

  return ___EmotionJSX("div", _extends({
    role: "group",
    className: classes
  }, rest), ___EmotionJSX(EuiFlexGroup, {
    alignItems: "baseline",
    gutterSize: gutterSize
  }, ___EmotionJSX(EuiFlexItem, _extends({
    grow: 1
  }, descriptionFlexItemProps, {
    className: classNames('euiDescribedFormGroup__descriptionColumn', descriptionFlexItemProps === null || descriptionFlexItemProps === void 0 ? void 0 : descriptionFlexItemProps.className)
  }), ___EmotionJSX(EuiTitle, {
    size: titleSize,
    className: "euiDescribedFormGroup__title"
  }, title), renderedDescription), ___EmotionJSX(EuiFlexItem, _extends({
    grow: fieldGrowth
  }, fieldFlexItemProps, {
    className: fieldClasses
  }), children)));
};