import _objectDestructuringEmpty from "@babel/runtime/helpers/objectDestructuringEmpty";

function _EMOTION_STRINGIFIED_CSS_ERROR__() { return "You have tried to stringify object returned from `css` function. It isn't supposed to be used directly (e.g. as value of the `className` prop), but rather handed to emotion so it can handle it (e.g. as value of `css` prop)."; }

/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
import { css } from '@emotion/react';
import { euiFontSize, logicalCSS, euiTextBreakWord, euiTextTruncate } from '../../global_styling';
import { transparentize } from '../../services/color';

var _colorCSS = function _colorCSS(color) {
  return "\n    &:focus {\n      background-color: ".concat(transparentize(color, 0.1), ";\n    }\n  ");
};

var _ref3 = process.env.NODE_ENV === "production" ? {
  name: "6151l-base",
  styles: "border-bottom-style:solid;label:base;"
} : {
  name: "6151l-base",
  styles: "border-bottom-style:solid;label:base;",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};

var _ref4 = process.env.NODE_ENV === "production" ? {
  name: "1372s1f-truncate",
  styles: "max-width:100%;label:truncate;"
} : {
  name: "1372s1f-truncate",
  styles: "max-width:100%;label:truncate;",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};

export var euiExpressionStyles = function euiExpressionStyles(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme;
  return {
    euiExpression: /*#__PURE__*/css(euiTextBreakWord(), ";font-family:", euiTheme.font.familyCode, ";border-bottom:", euiTheme.border.width.thick, " solid transparent;", euiFontSize(euiThemeContext, 's'), ";display:inline-block;text-align:left;padding:calc(", euiTheme.size.s, " / 2) 0;color:", euiTheme.colors.text, ";&:focus{border-bottom-style:solid;}&+.euiExpression{", logicalCSS('margin-left', euiTheme.size.s), ";};label:euiExpression;"),
    // Variants
    columns: /*#__PURE__*/css("border-color:transparent;border-bottom-style:solid;", logicalCSS('margin-bottom', euiTheme.size.xs), " width:100%;display:flex;padding:", euiTheme.size.xs, ";border-radius:", euiTheme.size.xs, ";;label:columns;"),
    truncate: _ref4,
    // States
    isClickable: /*#__PURE__*/css("cursor:pointer;border-bottom:", euiTheme.border.editable, ";&[class*='-columns']{background-color:", euiTheme.colors.lightestShade, ";&:focus,&:hover:not(:disabled){[class*='euiExpression__description'],[class*='euiExpression__value']{text-decoration:underline;}}};label:isClickable;"),
    isActive: {
      base: _ref3,
      subdued: /*#__PURE__*/css("border-color:", euiTheme.colors.subduedText, ";;label:subdued;"),
      primary: /*#__PURE__*/css("border-color:", euiTheme.colors.primary, ";;label:primary;"),
      success: /*#__PURE__*/css("border-color:", euiTheme.colors.success, ";;label:success;"),
      warning: /*#__PURE__*/css("border-color:", euiTheme.colors.warning, ";;label:warning;"),
      danger: /*#__PURE__*/css("border-color:", euiTheme.colors.danger, ";;label:danger;"),
      accent: /*#__PURE__*/css("border-color:", euiTheme.colors.accent, ";;label:accent;")
    },
    subdued: /*#__PURE__*/css(_colorCSS(euiTheme.colors.subduedText), ";label:subdued;"),
    primary: /*#__PURE__*/css(_colorCSS(euiTheme.colors.primaryText), ";label:primary;"),
    success: /*#__PURE__*/css(_colorCSS(euiTheme.colors.successText), ";label:success;"),
    warning: /*#__PURE__*/css(_colorCSS(euiTheme.colors.warningText), ";label:warning;"),
    danger: /*#__PURE__*/css(_colorCSS(euiTheme.colors.dangerText), ";label:danger;"),
    accent: /*#__PURE__*/css(_colorCSS(euiTheme.colors.accentText), ";label:accent;")
  };
};

var _ref2 = process.env.NODE_ENV === "production" ? {
  name: "shrg0y-isUppercase",
  styles: "text-transform:uppercase;label:isUppercase;"
} : {
  name: "shrg0y-isUppercase",
  styles: "text-transform:uppercase;label:isUppercase;",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};

export var euiExpressionDescriptionStyles = function euiExpressionDescriptionStyles(_ref5) {
  var euiTheme = _ref5.euiTheme;
  return {
    euiExpression__description: /*#__PURE__*/css(";label:euiExpression__description;"),
    truncate: /*#__PURE__*/css(euiTextTruncate(), " display:inline-block;vertical-align:bottom;;label:truncate;"),
    subdued: /*#__PURE__*/css("color:", euiTheme.colors.subduedText, ";;label:subdued;"),
    primary: /*#__PURE__*/css("color:", euiTheme.colors.primaryText, ";;label:primary;"),
    success: /*#__PURE__*/css("color:", euiTheme.colors.successText, ";;label:success;"),
    warning: /*#__PURE__*/css("color:", euiTheme.colors.warningText, ";;label:warning;"),
    danger: /*#__PURE__*/css("color:", euiTheme.colors.dangerText, ";;label:danger;"),
    accent: /*#__PURE__*/css("color:", euiTheme.colors.accentText, ";;label:accent;"),
    isUppercase: _ref2,
    columns: /*#__PURE__*/css("text-align:end;", logicalCSS('margin-right', euiTheme.size.s), ";flex-shrink:0;;label:columns;")
  };
};

var _ref = process.env.NODE_ENV === "production" ? {
  name: "29cdh2-columns",
  styles: "flex-grow:1;label:columns;"
} : {
  name: "29cdh2-columns",
  styles: "flex-grow:1;label:columns;",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};

export var euiExpressionValueStyles = function euiExpressionValueStyles(_ref6) {
  _objectDestructuringEmpty(_ref6);

  return {
    euiExpression__value: /*#__PURE__*/css(";label:euiExpression__value;"),
    truncate: /*#__PURE__*/css(euiTextTruncate(), " display:inline-block;vertical-align:bottom;;label:truncate;"),
    columns: _ref
  };
};
export var euiExpressionIconStyles = function euiExpressionIconStyles(_ref7) {
  var euiTheme = _ref7.euiTheme;
  return {
    euiExpression__icon: /*#__PURE__*/css(logicalCSS('margin-left', euiTheme.size.xs), ";;label:euiExpression__icon;"),
    columns: /*#__PURE__*/css(logicalCSS('margin-top', euiTheme.size.xs), ";;label:columns;")
  };
};