import _extends from "@babel/runtime/helpers/extends";
import _defineProperty from "@babel/runtime/helpers/defineProperty";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
var _excluded = ["destinationId", "overrideLinkBehavior", "tabIndex", "position", "children", "className"];

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) { symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); } keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
import React from 'react';
import classNames from 'classnames';
import { isTabbable } from 'tabbable';
import { useEuiTheme } from '../../../services';
import { EuiButton } from '../../button/button';
import { EuiScreenReaderOnly } from '../screen_reader_only';
import { euiSkipLinkStyles } from './skip_link.styles';
import { jsx as ___EmotionJSX } from "@emotion/react";
export var POSITIONS = ['static', 'fixed', 'absolute'];
export var EuiSkipLink = function EuiSkipLink(_ref) {
  var destinationId = _ref.destinationId,
      overrideLinkBehavior = _ref.overrideLinkBehavior,
      tabIndex = _ref.tabIndex,
      _ref$position = _ref.position,
      position = _ref$position === void 0 ? 'static' : _ref$position,
      children = _ref.children,
      className = _ref.className,
      rest = _objectWithoutProperties(_ref, _excluded);

  var euiTheme = useEuiTheme();
  var styles = euiSkipLinkStyles(euiTheme);
  var classes = classNames('euiSkipLink', className);
  var cssStyles = [styles.euiSkipLink, position !== 'static' ? styles[position] : undefined]; // Create the `href` from `destinationId`

  var optionalProps = {};

  if (destinationId) {
    optionalProps = {
      href: "#".concat(destinationId)
    };
  }

  if (overrideLinkBehavior) {
    optionalProps = _objectSpread(_objectSpread({}, optionalProps), {}, {
      onClick: function onClick(e) {
        e.preventDefault();
        var destinationEl = document.getElementById(destinationId);
        if (!destinationEl) return; // Scroll to the top of the destination content only if it's ~mostly out of view

        var destinationY = destinationEl.getBoundingClientRect().top;
        var halfOfViewportHeight = window.innerHeight / 2;

        if (destinationY >= halfOfViewportHeight || window.scrollY >= destinationY + halfOfViewportHeight) {
          destinationEl.scrollIntoView();
        } // Ensure the destination content is focusable


        if (!isTabbable(destinationEl)) {
          destinationEl.tabIndex = -1;
          destinationEl.addEventListener('blur', function () {
            return destinationEl.removeAttribute('tabindex');
          }, {
            once: true
          });
        }

        destinationEl.focus({
          preventScroll: true
        }); // Scrolling is already handled above, and focus autoscroll behaves oddly on Chrome around fixed headers
      }
    });
  }

  return ___EmotionJSX(EuiScreenReaderOnly, {
    showOnFocus: true
  }, ___EmotionJSX(EuiButton, _extends({
    css: cssStyles,
    className: classes,
    tabIndex: position === 'fixed' ? 0 : tabIndex,
    size: "s",
    fill: true
  }, optionalProps, rest), children));
};