import _slicedToArray from "@babel/runtime/helpers/slicedToArray";

/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
import React, { useEffect, useRef, useState } from 'react';
import { EuiScreenReaderOnly } from '../screen_reader_only';
import { jsx as ___EmotionJSX } from "@emotion/react";
export var EuiScreenReaderLive = function EuiScreenReaderLive(_ref) {
  var children = _ref.children,
      _ref$isActive = _ref.isActive,
      isActive = _ref$isActive === void 0 ? true : _ref$isActive,
      _ref$role = _ref.role,
      role = _ref$role === void 0 ? 'status' : _ref$role,
      _ref$ariaLive = _ref['aria-live'],
      ariaLive = _ref$ariaLive === void 0 ? 'polite' : _ref$ariaLive,
      _ref$focusRegionOnTex = _ref.focusRegionOnTextChange,
      focusRegionOnTextChange = _ref$focusRegionOnTex === void 0 ? false : _ref$focusRegionOnTex;

  var _useState = useState(false),
      _useState2 = _slicedToArray(_useState, 2),
      toggle = _useState2[0],
      setToggle = _useState2[1];

  var focusRef = useRef(null);
  useEffect(function () {
    setToggle(function (toggle) {
      return !toggle;
    });
  }, [children]);
  useEffect(function () {
    if (focusRef.current !== null && focusRegionOnTextChange) {
      focusRef.current.focus();
    }
  }, [toggle, focusRegionOnTextChange]);
  return (
    /**
     * Intentionally uses two persistent live regions with oscillating content updates.
     * This resolves the problem of duplicate screen reader announcements in rapid succession
     * caused by React's virtual DOM behaviour (https://github.com/nvaccess/nvda/issues/7996#issuecomment-413641709)
     *
     * Adapted from https://github.com/alphagov/accessible-autocomplete/blob/a7106f03150941fc15e6c1ceb0a90e8872fa86ef/src/status.js
     * Debouncing was not needed for this case, but could prove to be useful for future use cases.
     * See also https://github.com/AlmeroSteyn/react-aria-live and https://github.com/dequelabs/ngA11y
     * for more examples of the double region approach.
     */
    ___EmotionJSX(EuiScreenReaderOnly, null, ___EmotionJSX("div", {
      ref: focusRef,
      tabIndex: focusRegionOnTextChange ? -1 : undefined
    }, ___EmotionJSX("div", {
      role: role,
      "aria-atomic": "true" // Setting `aria-hidden` and setting `aria-live` to "off" prevents
      // double announcements from VO when `focusRegionOnTextChange` is true
      ,
      "aria-hidden": toggle ? undefined : 'true',
      "aria-live": focusRegionOnTextChange ? 'off' : ariaLive
    }, isActive && toggle ? children : ''), ___EmotionJSX("div", {
      role: role,
      "aria-atomic": "true",
      "aria-hidden": !toggle ? undefined : 'true',
      "aria-live": focusRegionOnTextChange ? 'off' : ariaLive
    }, isActive && !toggle ? children : '')))
  );
};