"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.euiStatTitleStyles = exports.euiStatStyles = void 0;

var _react = require("@emotion/react");

var _global_styling = require("../../global_styling");

var _templateObject;

function _taggedTemplateLiteral(strings, raw) { if (!raw) { raw = strings.slice(0); } return Object.freeze(Object.defineProperties(strings, { raw: { value: Object.freeze(raw) } })); }

var euiStatStyles = function euiStatStyles() {
  return {
    euiStat: /*#__PURE__*/(0, _react.css)(";label:euiStat;"),
    // Text align
    left: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalTextAlignCSS)('left'), " align-items:flex-start;;label:left;"),
    center: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalTextAlignCSS)('center'), " align-items:center;;label:center;"),
    right: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalTextAlignCSS)('right'), " align-items:flex-end;;label:right;")
  };
};

exports.euiStatStyles = euiStatStyles;

var euiStatTitleStyles = function euiStatTitleStyles(_ref) {
  var euiTheme = _ref.euiTheme;
  return {
    euiStat__title: /*#__PURE__*/(0, _react.css)(";label:euiStat__title;"),
    // Colors
    default: /*#__PURE__*/(0, _react.css)("color:", euiTheme.colors.fullShade, ";;label:default;"),
    subdued: /*#__PURE__*/(0, _react.css)("color:", euiTheme.colors.subduedText, ";;label:subdued;"),
    primary: /*#__PURE__*/(0, _react.css)("color:", euiTheme.colors.primaryText, ";;label:primary;"),
    success: /*#__PURE__*/(0, _react.css)("color:", euiTheme.colors.successText, ";;label:success;"),
    danger: /*#__PURE__*/(0, _react.css)("color:", euiTheme.colors.dangerText, ";;label:danger;"),
    accent: /*#__PURE__*/(0, _react.css)("color:", euiTheme.colors.accentText, ";;label:accent;"),
    // Loading
    isLoading: /*#__PURE__*/(0, _react.css)(_global_styling.euiCanAnimate, "{animation:", euiStatPulse, " 1.5s infinite ease-in-out;};label:isLoading;")
  };
};

exports.euiStatTitleStyles = euiStatTitleStyles;
var euiStatPulse = (0, _react.keyframes)(_templateObject || (_templateObject = _taggedTemplateLiteral(["\n  0% { opacity: 1; }\n  50% { opacity: .25; }\n  100% { opacity: 1; }\n"])));