"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiDescribedFormGroup = void 0;

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _classnames = _interopRequireDefault(require("classnames"));

var _title = require("../../title");

var _text = require("../../text");

var _flex = require("../../flex");

var _react2 = require("@emotion/react");

var _excluded = ["children", "className", "gutterSize", "fullWidth", "ratio", "titleSize", "title", "description", "descriptionFlexItemProps", "fieldFlexItemProps"];

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

var EuiDescribedFormGroup = function EuiDescribedFormGroup(_ref) {
  var children = _ref.children,
      className = _ref.className,
      _ref$gutterSize = _ref.gutterSize,
      gutterSize = _ref$gutterSize === void 0 ? 'l' : _ref$gutterSize,
      _ref$fullWidth = _ref.fullWidth,
      fullWidth = _ref$fullWidth === void 0 ? false : _ref$fullWidth,
      _ref$ratio = _ref.ratio,
      ratio = _ref$ratio === void 0 ? 'half' : _ref$ratio,
      _ref$titleSize = _ref.titleSize,
      titleSize = _ref$titleSize === void 0 ? 'xs' : _ref$titleSize,
      title = _ref.title,
      description = _ref.description,
      descriptionFlexItemProps = _ref.descriptionFlexItemProps,
      fieldFlexItemProps = _ref.fieldFlexItemProps,
      rest = _objectWithoutProperties(_ref, _excluded);

  var classes = (0, _classnames.default)('euiDescribedFormGroup', {
    'euiDescribedFormGroup--fullWidth': fullWidth
  }, className);
  var fieldClasses = (0, _classnames.default)('euiDescribedFormGroup__fields', fieldFlexItemProps && fieldFlexItemProps.className);
  var renderedDescription;

  if (description) {
    // If the description is just a string, wrap it in a paragraph element
    if (typeof description === 'string') {
      description = (0, _react2.jsx)("p", null, description);
    }

    renderedDescription = (0, _react2.jsx)(_text.EuiText, {
      size: "s",
      color: "subdued",
      className: "euiDescribedFormGroup__description"
    }, description);
  }

  var fieldGrowth;

  switch (ratio) {
    case 'half':
      fieldGrowth = 1;
      break;

    case 'third':
      fieldGrowth = 2;
      break;

    case 'quarter':
      fieldGrowth = 3;
      break;

    default:
      console.warn('Please provide an allowed ratio to EuiDescribedFromRow');
      break;
  }

  return (0, _react2.jsx)("div", _extends({
    role: "group",
    className: classes
  }, rest), (0, _react2.jsx)(_flex.EuiFlexGroup, {
    alignItems: "baseline",
    gutterSize: gutterSize
  }, (0, _react2.jsx)(_flex.EuiFlexItem, _extends({
    grow: 1
  }, descriptionFlexItemProps, {
    className: (0, _classnames.default)('euiDescribedFormGroup__descriptionColumn', descriptionFlexItemProps === null || descriptionFlexItemProps === void 0 ? void 0 : descriptionFlexItemProps.className)
  }), (0, _react2.jsx)(_title.EuiTitle, {
    size: titleSize,
    className: "euiDescribedFormGroup__title"
  }, title), renderedDescription), (0, _react2.jsx)(_flex.EuiFlexItem, _extends({
    grow: fieldGrowth
  }, fieldFlexItemProps, {
    className: fieldClasses
  }), children)));
};

exports.EuiDescribedFormGroup = EuiDescribedFormGroup;
EuiDescribedFormGroup.propTypes = {
  className: _propTypes.default.string,
  "aria-label": _propTypes.default.string,
  "data-test-subj": _propTypes.default.string,

  /**
       * One or more `EuiFormRow`s.
       */
  children: _propTypes.default.node,

  /**
       * Passed to `EuiFlexGroup`.
       */
  gutterSize: _propTypes.default.oneOf(["none", "xs", "s", "m", "l", "xl"]),

  /**
       * Expand to fill 100% of the parent.
       * Default max-width is 800px.
       */
  fullWidth: _propTypes.default.bool,

  /**
       * Width ratio of description column compared to field column.
       * Can be used in conjunction with `fullWidth` and
       * may require `fullWidth` to be applied to child elements.
       */
  ratio: _propTypes.default.oneOf(["half", "third", "quarter"]),

  /**
       * For better accessibility, it's recommended to use an HTML heading.
       */
  title: _propTypes.default.element.isRequired,

  /**
       * Adjust the visual `size` of the EuiTitle that wraps `title`.
       */
  titleSize: _propTypes.default.any,

  /**
       * Added as a child of `EuiText`.
       */
  description: _propTypes.default.node,

  /**
       * For customizing the field container. Extended from `EuiFlexItem`.
       */
  descriptionFlexItemProps: _propTypes.default.any,
  fieldFlexItemProps: _propTypes.default.any
};