/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
import { css } from '@emotion/react';
import { shade, tint, transparentize, useEuiTheme } from '../../services';
export var BACKGROUND_COLORS = ['transparent', 'plain', 'subdued', 'accent', 'primary', 'success', 'warning', 'danger'];
export var euiBackgroundColor = function euiBackgroundColor(_ref, color) {
  var euiTheme = _ref.euiTheme,
      colorMode = _ref.colorMode;

  var _ref2 = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {},
      method = _ref2.method;

  if (color === 'transparent') return 'transparent';

  if (method === 'transparent') {
    if (color === 'plain') {
      return transparentize(euiTheme.colors.ghost, 0.2);
    } else if (color === 'subdued') {
      return transparentize(euiTheme.colors.lightShade, 0.2);
    } else {
      return transparentize(euiTheme.colors[color], 0.1);
    }
  } else {
    var tintOrShade = function tintOrShade(color) {
      return colorMode === 'DARK' ? shade(color, 0.8) : tint(color, 0.9);
    };

    switch (color) {
      case 'plain':
        return euiTheme.colors.emptyShade;

      case 'subdued':
        return euiTheme.colors.body;

      default:
        return tintOrShade(euiTheme.colors[color]);
    }
  }
};
export var useEuiBackgroundColor = function useEuiBackgroundColor(color) {
  var _ref3 = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {},
      method = _ref3.method;

  var euiTheme = useEuiTheme();
  return euiBackgroundColor(euiTheme, color, {
    method: method
  });
};
export var useEuiBackgroundColorCSS = function useEuiBackgroundColorCSS() {
  return {
    transparent: /*#__PURE__*/css("background-color:", useEuiBackgroundColor('transparent'), ";;label:transparent;"),
    plain: /*#__PURE__*/css("background-color:", useEuiBackgroundColor('plain'), ";;label:plain;"),
    subdued: /*#__PURE__*/css("background-color:", useEuiBackgroundColor('subdued'), ";;label:subdued;"),
    accent: /*#__PURE__*/css("background-color:", useEuiBackgroundColor('accent'), ";;label:accent;"),
    primary: /*#__PURE__*/css("background-color:", useEuiBackgroundColor('primary'), ";;label:primary;"),
    success: /*#__PURE__*/css("background-color:", useEuiBackgroundColor('success'), ";;label:success;"),
    warning: /*#__PURE__*/css("background-color:", useEuiBackgroundColor('warning'), ";;label:warning;"),
    danger: /*#__PURE__*/css("background-color:", useEuiBackgroundColor('danger'), ";;label:danger;")
  };
};