var _excluded = ["children", "verticalAlign", "icon", "iconAriaLabel", "className"];

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
import React from 'react';
import PropTypes from "prop-types";
import { EuiTimelineItemEvent } from './timeline_item_event';
import { EuiTimelineItemIcon } from './timeline_item_icon';
import { euiTimelineItemStyles } from './timeline_item.styles';
import { jsx as ___EmotionJSX } from "@emotion/react";
export var VERTICAL_ALIGN = ['top', 'center'];
export var EuiTimelineItem = function EuiTimelineItem(_ref) {
  var children = _ref.children,
      _ref$verticalAlign = _ref.verticalAlign,
      verticalAlign = _ref$verticalAlign === void 0 ? 'center' : _ref$verticalAlign,
      icon = _ref.icon,
      iconAriaLabel = _ref.iconAriaLabel,
      className = _ref.className,
      rest = _objectWithoutProperties(_ref, _excluded);

  var styles = euiTimelineItemStyles();
  var cssStyles = [styles.euiTimelineItem, styles[verticalAlign]];
  return ___EmotionJSX("li", _extends({
    css: cssStyles
  }, rest), ___EmotionJSX(EuiTimelineItemIcon, {
    icon: icon,
    iconAriaLabel: iconAriaLabel,
    verticalAlign: verticalAlign
  }), ___EmotionJSX(EuiTimelineItemEvent, {
    verticalAlign: verticalAlign
  }, children));
};
EuiTimelineItem.propTypes = {
  /**
     * Vertical alignment of the event with the icon
     */
  verticalAlign: PropTypes.any,
  className: PropTypes.string,
  "aria-label": PropTypes.string,
  "data-test-subj": PropTypes.string
};