var _excluded = ["className", "items", "children", "gutterSize"];

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
import React from 'react';
import PropTypes from "prop-types";
import classNames from 'classnames';
import { useEuiTheme } from '../../services';
import { EuiTimelineItem } from './timeline_item';
import { euiTimelineStyles } from './timeline.styles';
import { jsx as ___EmotionJSX } from "@emotion/react";
export var GUTTER_SIZES = ['m', 'l', 'xl'];
export var EuiTimeline = function EuiTimeline(_ref) {
  var className = _ref.className,
      _ref$items = _ref.items,
      items = _ref$items === void 0 ? [] : _ref$items,
      children = _ref.children,
      _ref$gutterSize = _ref.gutterSize,
      gutterSize = _ref$gutterSize === void 0 ? 'xl' : _ref$gutterSize,
      rest = _objectWithoutProperties(_ref, _excluded);

  var classes = classNames('euiTimeline', className);
  var euiTheme = useEuiTheme();
  var styles = euiTimelineStyles(euiTheme);
  var cssStyles = [styles.euiTimeline, styles[gutterSize]];
  return (// eslint-disable-next-line jsx-a11y/no-redundant-roles
    ___EmotionJSX("ol", _extends({
      className: classes,
      css: cssStyles,
      role: "list"
    }, rest), items.map(function (item, index) {
      return ___EmotionJSX(EuiTimelineItem, _extends({
        key: index
      }, item));
    }), children)
  );
};
EuiTimeline.propTypes = {
  /**
     * List of timeline items to render. See #EuiTimelineItem
     */
  items: PropTypes.arrayOf(PropTypes.shape({
    /**
       * Vertical alignment of the event with the icon
       */
    verticalAlign: PropTypes.any,
    className: PropTypes.string,
    "aria-label": PropTypes.string,
    "data-test-subj": PropTypes.string
  }).isRequired),

  /**
     * Sets the size of the vertical space between each timeline item
     */
  gutterSize: PropTypes.any,
  className: PropTypes.string,
  "aria-label": PropTypes.string,
  "data-test-subj": PropTypes.string
};