var _excluded = ["children", "color", "component", "cloneElement", "style"];

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) { symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); } keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
import React, { isValidElement } from 'react';
import PropTypes from "prop-types";
import { cloneElementWithCss } from '../../services/theme/clone_element';
import { useEuiTheme } from '../../services';
import { euiTextColorStyles } from './text_color.styles';
import { jsx as ___EmotionJSX } from "@emotion/react";
export var COLORS = ['default', 'subdued', 'success', 'accent', 'danger', 'warning', 'ghost', 'inherit'];
export var EuiTextColor = function EuiTextColor(_ref) {
  var children = _ref.children,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? 'default' : _ref$color,
      _ref$component = _ref.component,
      component = _ref$component === void 0 ? 'span' : _ref$component,
      _ref$cloneElement = _ref.cloneElement,
      cloneElement = _ref$cloneElement === void 0 ? false : _ref$cloneElement,
      style = _ref.style,
      rest = _objectWithoutProperties(_ref, _excluded);

  var isNamedColor = COLORS.includes(color);
  var euiTheme = useEuiTheme();
  var styles = euiTextColorStyles(euiTheme);
  var cssStyles = [styles.euiTextColor, isNamedColor ? styles[color] : styles.customColor]; // We're checking if is a custom color.
  // If it is a custom color we set the `color` of the `.euiTextColor` div to that custom color.
  // This way the children text elements can `inherit` that color and border and backgrounds can get that `currentColor`.

  var euiTextStyle = !isNamedColor ? _objectSpread({
    color: color
  }, style) : _objectSpread({}, style);

  var props = _objectSpread({
    css: cssStyles,
    style: euiTextStyle
  }, rest);

  if ( /*#__PURE__*/isValidElement(children) && cloneElement) {
    var childrenStyle = _objectSpread(_objectSpread({}, children.props.style), euiTextStyle);

    return cloneElementWithCss(children, _objectSpread(_objectSpread({}, props), {}, {
      style: childrenStyle
    }));
  } else {
    var Component = component;
    return ___EmotionJSX(Component, props, children);
  }
};
EuiTextColor.propTypes = {
  className: PropTypes.string,
  "aria-label": PropTypes.string,
  "data-test-subj": PropTypes.string,

  /**
       * Any of our named colors or a `hex`, `rgb` or `rgba` value.
       */
  color: PropTypes.oneOfType([PropTypes.any.isRequired, PropTypes.any.isRequired]),

  /**
       * Determines the root element
       */
  component: PropTypes.oneOf(["div", "span"]),

  /**
       * Applies text styling to the child element instead of rendering a parent wrapper `span`/`div`.
       * Can only be used when wrapping a *single* child element/tag, and not raw text.
       */
  cloneElement: PropTypes.bool
};