/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
import { css } from '@emotion/react';
import { logicalCSS, euiFontSize, euiBackgroundColor } from '../../global_styling';
import { euiLinkCSS } from '../link/link.styles';
import { euiTitle } from '../title/title.styles';
/**
 * TODO: Make this a global value so it can be set by theme?
 */

export var euiTextConstrainedMaxWidth = 'max(64ch, 75%)';
/**
 * Mixins
 */

export var euiText = function euiText(euiTheme) {
  var inheritColor = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;
  return {
    color: inheritColor ? 'inherit' : euiTheme.colors.text,
    fontWeight: euiTheme.font.weight.regular
  };
}; // Internal utility for EuiText scales/sizes

var euiScaleText = function euiScaleText(euiThemeContext, options) {
  var _euiFontSize = euiFontSize(euiThemeContext, 'm', options),
      fontSize = _euiFontSize.fontSize,
      lineHeight = _euiFontSize.lineHeight;

  var euiTheme = euiThemeContext.euiTheme;
  var measurement = options.measurement,
      _customScale = options.customScale;
  var lineHeightSize = measurement === 'em' ? "".concat(lineHeight, "em") : lineHeight;
  var headings = {
    h1: euiTitle(euiThemeContext, 'l', options),
    h2: euiTitle(euiThemeContext, 'm', options),
    h3: euiTitle(euiThemeContext, 's', options),
    h4: euiTitle(euiThemeContext, 'xs', options),
    h5: euiTitle(euiThemeContext, 'xxs', options),
    h6: euiTitle(euiThemeContext, 'xxxs', options)
  }; // Generate margins for headings based on customScale (not on heading level)

  var customScale = _customScale === 'xxxs' ? 'xxs' : _customScale || 'm';
  var headingMarginTop = "".concat(parseFloat(euiTheme.size[customScale]) * 2, "px");
  var headingMarginBottom = euiTheme.size[customScale];
  return "\n    font-size: ".concat(fontSize, ";\n    line-height: ").concat(lineHeight, ";\n\n    h1 {\n      font-size: ").concat(headings.h1.fontSize, ";\n      line-height: ").concat(headings.h1.lineHeight, ";\n    }\n    h1:not(:last-child) {\n      ").concat(logicalCSS('margin-bottom', headingMarginBottom), "\n    }\n\n    h2 {\n      font-size: ").concat(headings.h2.fontSize, ";\n      line-height: ").concat(headings.h2.lineHeight, ";\n\n      &:not(:first-child) {\n        ").concat(logicalCSS('margin-top', headingMarginTop), "\n      }\n\n      &:not(:last-child) {\n        ").concat(logicalCSS('margin-bottom', headingMarginBottom), "\n      }\n    }\n\n    h3 {\n      font-size: ").concat(headings.h3.fontSize, ";\n      line-height: ").concat(headings.h3.lineHeight, ";\n\n      &:not(:first-child) {\n        ").concat(logicalCSS('margin-top', headingMarginTop), "\n      }\n\n      &:not(:last-child) {\n        ").concat(logicalCSS('margin-bottom', headingMarginBottom), "\n      }\n    }\n\n    h4 {\n      font-size: ").concat(headings.h4.fontSize, ";\n      line-height: ").concat(headings.h4.lineHeight, ";\n\n      &:not(:first-child) {\n        ").concat(logicalCSS('margin-top', headingMarginTop), "\n      }\n\n      &:not(:last-child) {\n        ").concat(logicalCSS('margin-bottom', headingMarginBottom), "\n      }\n    }\n\n    h5 {\n      font-size: ").concat(headings.h5.fontSize, ";\n      line-height: ").concat(headings.h5.lineHeight, ";\n\n      &:not(:first-child) {\n        ").concat(logicalCSS('margin-top', headingMarginTop), "\n      }\n\n      &:not(:last-child) {\n        ").concat(logicalCSS('margin-bottom', headingMarginBottom), "\n      }\n    }\n\n    h6 {\n      font-size: ").concat(headings.h6.fontSize, ";\n      line-height: ").concat(headings.h6.lineHeight, ";\n\n      &:not(:first-child) {\n        ").concat(logicalCSS('margin-top', headingMarginTop), "\n      }\n\n      &:not(:last-child) {\n        ").concat(logicalCSS('margin-bottom', headingMarginBottom), "\n      }\n    }\n\n    p,\n    ul,\n    ol,\n    dl,\n    blockquote,\n    img,\n    pre {\n      ").concat(logicalCSS('margin-bottom', lineHeightSize), "\n    }\n\n    ul,\n    ol {\n      ").concat(logicalCSS('margin-left', lineHeightSize), "\n    }\n  \n    blockquote {\n      font-size: ").concat(fontSize, ";\n      padding: ").concat(lineHeightSize, ";\n    }\n\n    dd + dt {\n      ").concat(logicalCSS('margin-top', fontSize), "\n    }\n\n    dt,\n    .eui-definitionListReverse dd {\n      font-size: ").concat(fontSize, ";\n      line-height: ").concat(lineHeight, ";\n    }\n\n    .eui-definitionListReverse dt {\n      font-size: ").concat(euiFontSize(euiThemeContext, 'xs', options).fontSize, ";\n      color: ").concat(euiTheme.colors.text, ";\n    }\n\n    small {\n      font-size: ").concat(euiFontSize(euiThemeContext, 's', options).fontSize, ";\n    }\n\n    pre:not(.euiCodeBlock__pre) {\n      padding: ").concat(lineHeightSize, ";\n    }\n\n    code:not(.euiCode):not(.euiCodeBlock__code)  {\n      font-size: .9em; // 90% of parent font size\n    }\n  ");
};
/**
 * Styles
 */


export var euiTextStyles = function euiTextStyles(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme;
  return {
    euiText: /*#__PURE__*/css(euiText(euiTheme, true), ";clear:both;a:not([class]){", euiLinkCSS(euiTheme), ";}img{display:block;width:100%;}ul{list-style:disc;}ol{list-style:decimal;}blockquote:not(.euiMarkdownFormat__blockquote){position:relative;text-align:center;", logicalCSS('margin-horizontal', 'auto'), " font-family:", euiTheme.font.familySerif, ";font-style:italic;letter-spacing:normal;p:last-child{margin-bottom:0;}&:before,&:after{position:absolute;content:'';height:", euiTheme.border.width.thick, ";width:50%;right:0;transform:translateX(-50%);background:", euiTheme.colors.darkShade, ";}&:before{top:0;}&:after{bottom:0;}}h1{", euiTitle(euiThemeContext, 'l'), ";}h2{", euiTitle(euiThemeContext, 'm'), ";}h3{", euiTitle(euiThemeContext, 's'), ";}h4,dt{", euiTitle(euiThemeContext, 'xs'), ";}h5{", euiTitle(euiThemeContext, 'xxs'), ";}h6{", euiTitle(euiThemeContext, 'xxxs'), " text-transform:uppercase;}h1,h2,h3,h4,h5,h6,dt{color:inherit;}pre:not(.euiCodeBlock__pre){white-space:pre-wrap;background:", euiBackgroundColor(euiThemeContext, 'subdued'), ";color:", euiTheme.colors.text, ";}pre:not(.euiCodeBlock__pre),pre:not(.euiCodeBlock__pre) code{display:block;}>:last-child{margin-bottom:0!important;};label:euiText;"),
    constrainedWidth: /*#__PURE__*/css("max-width:", euiTextConstrainedMaxWidth, ";;label:constrainedWidth;"),
    // Sizes
    m: /*#__PURE__*/css(euiScaleText(euiThemeContext, {
      measurement: 'rem',
      customScale: 'm'
    }), ";;label:m;"),
    s: /*#__PURE__*/css(euiScaleText(euiThemeContext, {
      measurement: 'rem',
      customScale: 's'
    }), ";;label:s;"),
    xs: /*#__PURE__*/css(euiScaleText(euiThemeContext, {
      measurement: 'rem',
      customScale: 'xs'
    }), ";;label:xs;"),
    relative: /*#__PURE__*/css(euiScaleText(euiThemeContext, {
      measurement: 'em'
    }), ";;label:relative;")
  };
};