function _EMOTION_STRINGIFIED_CSS_ERROR__() { return "You have tried to stringify object returned from `css` function. It isn't supposed to be used directly (e.g. as value of the `className` prop), but rather handed to emotion so it can handle it (e.g. as value of `css` prop)."; }

/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
import { css } from '@emotion/react';
import { euiShadow } from '../../themes/amsterdam/global_styling/mixins';
import { euiCanAnimate, logicalTextAlignCSS } from '../../global_styling';

var _ref = process.env.NODE_ENV === "production" ? {
  name: "122lw0e-grow",
  styles: "flex-grow:1;label:grow;"
} : {
  name: "122lw0e-grow",
  styles: "flex-grow:1;label:grow;",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};

var _ref2 = process.env.NODE_ENV === "production" ? {
  name: "1kk7odi-euiPanel",
  styles: "flex-grow:0;label:euiPanel;"
} : {
  name: "1kk7odi-euiPanel",
  styles: "flex-grow:0;label:euiPanel;",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};

export var euiPanelStyles = function euiPanelStyles(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme;
  return {
    // Base
    euiPanel: _ref2,
    grow: _ref,
    hasShadow: /*#__PURE__*/css(euiShadow(euiThemeContext, 'm'), ";;label:hasShadow;"),
    hasBorder: /*#__PURE__*/css("border:", euiTheme.border.thin, ";;label:hasBorder;"),
    radius: {
      none: /*#__PURE__*/css(";label:none;"),
      m: /*#__PURE__*/css("border-radius:", euiTheme.border.radius.medium, ";;label:m;")
    },
    // Setup interactive behavior
    isClickable: /*#__PURE__*/css(euiCanAnimate, "{transition:box-shadow ", euiTheme.animation.fast, " ", euiTheme.animation.resistance, ",transform ", euiTheme.animation.fast, " ", euiTheme.animation.resistance, ";}&:enabled{display:block;width:100%;", logicalTextAlignCSS('left'), ";}&:hover,&:focus{", euiShadow(euiThemeContext, 'l'), ";transform:translateY(-2px);cursor:pointer;};label:isClickable;")
  };
};