var _templateObject, _templateObject2, _templateObject3;

function _taggedTemplateLiteral(strings, raw) { if (!raw) { raw = strings.slice(0); } return Object.freeze(Object.defineProperties(strings, { raw: { value: Object.freeze(raw) } })); }

/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
import { css, keyframes } from '@emotion/react';
import { euiCanAnimate } from '../../global_styling';
var loadingPulsateAndFade = keyframes(_templateObject || (_templateObject = _taggedTemplateLiteral(["\n  0% {\n    opacity: 0;\n  }\n\n  50% {\n    transform: scale(.5);\n    opacity: .1;\n  }\n\n  100% {\n    opacity: 0;\n  }\n"])));
var loadingPulsate = keyframes(_templateObject2 || (_templateObject2 = _taggedTemplateLiteral(["\n  0% {\n    opacity: .15;\n  }\n\n  50% {\n    transform: scale(.5);\n    opacity: .05;\n  }\n\n  100% {\n    opacity: .15;\n  }\n"])));
var loadingBounce = keyframes(_templateObject3 || (_templateObject3 = _taggedTemplateLiteral(["\n  50% {\n    transform: translateY(-50%);\n  }\n"])));
var loadingPadding = {
  m: 'xxs',
  l: 'xs',
  xl: 's'
};
export var euiLoadingLogoStyles = function euiLoadingLogoStyles(_ref) {
  var euiTheme = _ref.euiTheme;
  return {
    euiLoadingLogo: /*#__PURE__*/css("position:relative;display:inline-block;", euiCanAnimate, "{&:before,&:after{position:absolute;content:'';width:90%;inset-inline-start:5%;border-radius:50%;opacity:0.2;z-index:1;}&:before{box-shadow:0 0 ", euiTheme.size.s, " ", euiTheme.colors.fullShade, ";animation:1s ", loadingPulsateAndFade, " ", euiTheme.animation.resistance, " infinite;}&:after{background-color:", euiTheme.colors.fullShade, ";animation:1s ", loadingPulsate, " ", euiTheme.animation.resistance, " infinite;}};label:euiLoadingLogo;"),

    /**
     * 1. Requires pixel math for animation
     * 2. Add a half the amount of animation distance padding to the top to give it more room
     */
    m: /*#__PURE__*/css(euiCanAnimate, "{padding-block-start:", euiTheme.size[loadingPadding.m], ";}&:before,&:after{height:", euiTheme.base * 0.25, "px;inset-block-end:-", euiTheme.size.xs, ";};label:m;"),
    l: /*#__PURE__*/css(euiCanAnimate, "{padding-block-start:", euiTheme.size[loadingPadding.l], ";}&:before,&:after{height:", euiTheme.base * 0.375, "px;inset-block-end:-", euiTheme.size.s, ";};label:l;"),
    xl: /*#__PURE__*/css(euiCanAnimate, "{padding-block-start:", euiTheme.size[loadingPadding.xl], ";}&:before,&:after{height:", euiTheme.base * 0.5, "px;inset-block-end:-", euiTheme.size.m, ";};label:xl;")
  };
};
export var euiLoadingLogoIconStyles = function euiLoadingLogoIconStyles(_ref2) {
  var euiTheme = _ref2.euiTheme;
  return {
    euiLoadingLogo__icon: /*#__PURE__*/css("display:inline-block;", euiCanAnimate, "{animation:1s ", loadingBounce, " ", euiTheme.animation.resistance, " infinite;};label:euiLoadingLogo__icon;")
  };
};