var _templateObject;

function _taggedTemplateLiteral(strings, raw) { if (!raw) { raw = strings.slice(0); } return Object.freeze(Object.defineProperties(strings, { raw: { value: Object.freeze(raw) } })); }

/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
import { css, keyframes } from '@emotion/react';
import { euiCanAnimate } from '../../global_styling';
import { COLOR_MODES_STANDARD, shade, tint } from '../../services';
var loadingContentGradient = keyframes(_templateObject || (_templateObject = _taggedTemplateLiteral(["\n  0% {\n    transform: translateX(-53%);\n  }\n\n  100% {\n    transform: translateX(0);\n  }\n"])));
export var euiLoadingContentStyles = function euiLoadingContentStyles(_ref) {
  var euiTheme = _ref.euiTheme,
      colorMode = _ref.colorMode;
  var gradientStartStop = colorMode === COLOR_MODES_STANDARD.dark ? shade(euiTheme.colors.lightShade, 0.12) : tint(euiTheme.colors.lightShade, 0.65);
  var gradientMiddle = colorMode === COLOR_MODES_STANDARD.dark ? shade(euiTheme.colors.lightShade, 0.24) : tint(euiTheme.colors.lightShade, 0.8);
  return {
    euiLoadingContent__singleLine: /*#__PURE__*/css("display:block;width:100%;height:", euiTheme.size.base, ";border-radius:", euiTheme.border.radius.medium, ";background:", gradientStartStop, ";overflow:hidden;&:not(:last-child){margin-block-end:", euiTheme.size.s, ";}&:last-child:not(:only-child){width:75%;}&::after{content:'';display:block;width:220%;height:100%;background:linear-gradient(\n          137deg,\n          ", gradientStartStop, " 45%,\n          ", gradientMiddle, " 50%,\n          ", gradientStartStop, " 55%\n        );", euiCanAnimate, "{animation:", loadingContentGradient, " 1.5s ", euiTheme.animation.resistance, " infinite;}};label:euiLoadingContent__singleLine;")
  };
};