function _toConsumableArray(arr) { return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _unsupportedIterableToArray(arr) || _nonIterableSpread(); }

function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _iterableToArray(iter) { if (typeof Symbol !== "undefined" && iter[Symbol.iterator] != null || iter["@@iterator"] != null) return Array.from(iter); }

function _arrayWithoutHoles(arr) { if (Array.isArray(arr)) return _arrayLikeToArray(arr); }

function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { var _i = arr == null ? null : typeof Symbol !== "undefined" && arr[Symbol.iterator] || arr["@@iterator"]; if (_i == null) return; var _arr = []; var _n = true; var _d = false; var _s, _e; try { for (_i = _i.call(arr); !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
import React, { useMemo, useCallback } from 'react';
import { EuiI18n } from '../../i18n';
import { EuiButtonIcon } from '../../button/button_icon';
import { EuiButtonEmpty } from '../../button/button_empty';
import { EuiFlexGroup, EuiFlexItem } from '../../flex';
import { EuiPopoverFooter } from '../../popover';
import { jsx as ___EmotionJSX } from "@emotion/react";
export var EuiDataGridCellActions = function EuiDataGridCellActions(_ref) {
  var onExpandClick = _ref.onExpandClick,
      column = _ref.column,
      rowIndex = _ref.rowIndex,
      colIndex = _ref.colIndex;

  // Note: The cell expand button/expansion popover is *always* rendered if
  // column.cellActions is present (regardless of column.isExpandable).
  // This is because cell actions are not otherwise accessible to keyboard
  // or screen reader users
  var expandButton = ___EmotionJSX(EuiI18n, {
    key: 'expand',
    token: "euiDataGridCellActions.expandButtonTitle",
    default: "Click or hit enter to interact with cell content"
  }, function (expandButtonTitle) {
    return ___EmotionJSX(EuiButtonIcon, {
      display: "fill",
      className: "euiDataGridRowCell__actionButtonIcon",
      "data-test-subj": "euiDataGridCellExpandButton",
      color: "primary",
      iconSize: "s",
      iconType: "expandMini",
      "aria-hidden": true,
      onClick: onExpandClick,
      title: expandButtonTitle
    });
  });

  var additionalButtons = useMemo(function () {
    if (!column || !Array.isArray(column === null || column === void 0 ? void 0 : column.cellActions)) return [];

    var ButtonComponent = function ButtonComponent(props) {
      return ___EmotionJSX(EuiButtonIcon, _extends({}, props, {
        "aria-hidden": true,
        className: "euiDataGridRowCell__actionButtonIcon",
        iconSize: "s"
      }));
    };

    var _getVisibleCellAction = getVisibleCellActions(column === null || column === void 0 ? void 0 : column.cellActions, column === null || column === void 0 ? void 0 : column.visibleCellActions),
        _getVisibleCellAction2 = _slicedToArray(_getVisibleCellAction, 1),
        visibleCellActions = _getVisibleCellAction2[0];

    return visibleCellActions.map(function (Action, idx) {
      // React is more permissible than the TS types indicate
      var ActionButtonElement = Action;
      return ___EmotionJSX(ActionButtonElement, {
        key: idx,
        rowIndex: rowIndex,
        colIndex: colIndex,
        columnId: column.id,
        Component: ButtonComponent,
        isExpanded: false
      });
    });
  }, [column, colIndex, rowIndex]);
  return ___EmotionJSX("div", {
    className: "euiDataGridRowCell__expandActions"
  }, [].concat(_toConsumableArray(additionalButtons), [expandButton]));
};
export var EuiDataGridCellPopoverActions = function EuiDataGridCellPopoverActions(_ref2) {
  var rowIndex = _ref2.rowIndex,
      colIndex = _ref2.colIndex,
      column = _ref2.column;

  var _getVisibleCellAction3 = getVisibleCellActions(column === null || column === void 0 ? void 0 : column.cellActions, column === null || column === void 0 ? void 0 : column.visibleCellActions),
      _getVisibleCellAction4 = _slicedToArray(_getVisibleCellAction3, 2),
      primaryActions = _getVisibleCellAction4[0],
      secondaryActions = _getVisibleCellAction4[1];

  var renderActions = useCallback(function (Action, idx) {
    var ActionButtonElement = Action;
    return ___EmotionJSX(EuiFlexItem, {
      key: idx
    }, ___EmotionJSX("div", null, ___EmotionJSX(ActionButtonElement, {
      rowIndex: rowIndex,
      colIndex: colIndex,
      columnId: column.id,
      Component: function Component(props) {
        return ___EmotionJSX(EuiButtonEmpty, _extends({}, props, {
          size: "s"
        }));
      },
      isExpanded: true
    })));
  }, [column, colIndex, rowIndex]);
  return ___EmotionJSX(React.Fragment, null, primaryActions.length > 0 && ___EmotionJSX(EuiPopoverFooter, null, ___EmotionJSX(EuiFlexGroup, {
    gutterSize: "s",
    responsive: false,
    wrap: true
  }, primaryActions.map(renderActions))), secondaryActions.length > 0 && ___EmotionJSX(EuiPopoverFooter, null, ___EmotionJSX(EuiFlexGroup, {
    gutterSize: "s",
    direction: "column",
    alignItems: "flexStart"
  }, secondaryActions.map(renderActions))));
}; // Util helper to separate primary actions (columns.visibleCellActions, defaults to 2)
// and secondary actions (all remaning actions)

var getVisibleCellActions = function getVisibleCellActions(cellActions) {
  var visibleCellActions = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 2;
  if (!cellActions) return [[], []];
  if (cellActions.length <= visibleCellActions) return [cellActions, []];
  var primaryCellActions = cellActions.slice(0, visibleCellActions);
  var remainingCellActions = cellActions.slice(visibleCellActions);
  return [primaryCellActions, remainingCellActions];
};