"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.colorFrag = exports.roundedRectFrag = exports.roundedRectVert = exports.simpleRectVert = exports.GEOM_INDEX_OFFSET = exports.attributeLocations = void 0;
exports.attributeLocations = {
    position0: 0,
    position1: 1,
    size0: 2,
    size1: 3,
    color: 4,
};
exports.GEOM_INDEX_OFFSET = 1;
var vertTop = "#version 300 es\n  #pragma STDGL invariant(all)\n  precision highp int;\n  precision highp float;\n";
var fragTop = "#version 300 es\n  precision highp int;\n  precision highp float;\n";
var attribDefs = "\n  layout(location=".concat(exports.attributeLocations.position0, ") in vec2 position0;\n  layout(location=").concat(exports.attributeLocations.position1, ") in vec2 position1;\n  layout(location=").concat(exports.attributeLocations.size0, ") in float size0;\n  layout(location=").concat(exports.attributeLocations.size1, ") in float size1;\n  layout(location=").concat(exports.attributeLocations.color, ") in vec4 color;\n");
var uniformDefs = "\n  uniform Settings {\n    mat4 focus; // [[focusLoX, focusHiX], [focusLoY, focusHiY]]\n    vec2 resolution;\n    vec2 gapPx;\n    vec2 minFillRatio; // at least this ratio of the rectangle's full width/height must be filled\n    float rowHeight0;\n    float rowHeight1;\n    float t; // 0: start position; 1: end position\n    float cornerRadiusPx;\n    float hoverIndex;\n    float wobbleIndex;\n    float wobble;\n    bool pickLayer;\n  };\n";
var constants = "\n  const vec4 UNIT4 = vec4(1.0);\n  const uvec4 BIT_SHIFTERS = uvec4(24, 16, 8, 0); // helps pack a 32bit unsigned integer into the RGBA bytes\n  const float HOVER_OPACITY = 0.382; // arbitrary; set to the smaller part of the golden ratio\n  const int GEOM_INDEX_OFFSET = ".concat(exports.GEOM_INDEX_OFFSET, ";\n");
var structGeom = "\n  struct Geom {\n    vec2 unitSquareCoord;\n    vec2 size;\n    vec4 glPosition;\n    vec4 fragmentColor;\n  };\n";
var getViewable = "\n  vec2 getViewable() {\n    float viewableX = focus[0][1] - focus[0][0];\n    float viewableY = focus[1][1] - focus[1][0];\n    return vec2(viewableX, viewableY);\n  }\n";
var getGeom = "\n  Geom getGeom(vec2 viewable, vec2 gap, vec2 maxGapRatio) {\n    // calculate the basic geometry invariant of gaps, rounding or zoom levels\n    int x = gl_VertexID & 1;        // x yields 0, 1, 0, 1 for gl_VertexID 0, 1, 2, 3\n    int y = (gl_VertexID >> 1) & 1; // y yields 0, 0, 1, 1 for gl_VertexID 0, 1, 2, 3\n    vec2 unitSquareCoord = vec2(x, y);\n    vec2 position = mix(position0, position1, t);\n    vec2 size = mix(vec2(size0, rowHeight0), vec2(size1, rowHeight1), t);\n    vec2 fullSizeXY = size * unitSquareCoord;\n\n    // determine what we're zooming/panning into\n    vec2 baseXY = fullSizeXY + position;\n    vec2 pan = vec2(focus[0][0], focus[1][0]);\n\n    // gl_VertexID iterates as an integer index 0, 1, 2, ..., (offset + 0, offset + 1, ..., offset + count - 1)\n    // these four coordinates form a rectangle, set up as two counterclockwise triangles with gl.TRIANGLE_STRIP\n    // clip coordinate x/y goes from -1 to 1 of the viewport, so we center with this 0.5 subtraction\n    vec2 gr = min(gap, maxGapRatio * fullSizeXY);\n    vec2 xy = baseXY - unitSquareCoord * gr;\n    vec2 zoomPannedXY = (xy - pan) / viewable;\n\n    // output the position and color values (approx. return values of our vertex shader)\n    // project [0, 1] normalized values to [-1, 1] homogeneous clip space values\n    vec4 glPosition = vec4(2.0 * zoomPannedXY - 1.0, 0, 1);\n\n    vec4 fragmentColor = pickLayer\n      ? vec4((uvec4(gl_InstanceID + GEOM_INDEX_OFFSET) >> BIT_SHIFTERS) % uvec4(256)) / 255.0\n      : vec4(\n          color.rgb,\n          color.a\n            * (gl_InstanceID == int(hoverIndex) - GEOM_INDEX_OFFSET ? HOVER_OPACITY : 1.0)\n            * (gl_InstanceID == int(wobbleIndex) - GEOM_INDEX_OFFSET && wobble > 0.0 ? 1.0 - wobble : 1.0)\n        );\n\n    return Geom(\n      unitSquareCoord,\n      size,\n      glPosition,\n      fragmentColor\n    );\n  }\n";
exports.simpleRectVert = "".concat(vertTop, "\n  ").concat(attribDefs, "\n  ").concat(uniformDefs, "\n\n  out vec4 fragmentColor;\n\n  ").concat(constants, "\n  ").concat(structGeom, "\n  ").concat(getViewable, "\n  ").concat(getGeom, "\n\n  void main() {\n    Geom g = getGeom(getViewable(), vec2(0), vec2(0));\n    gl_Position = g.glPosition;\n    fragmentColor = g.fragmentColor;\n  }\n");
exports.roundedRectVert = "".concat(vertTop, "\n  ").concat(attribDefs, "\n  ").concat(uniformDefs, "\n\n  out vec4 fragmentColor;\n  out vec2 corners[4];\n  out float radiusPx;\n\n  ").concat(constants, "\n  ").concat(structGeom, "\n  ").concat(getViewable, "\n  ").concat(getGeom, "\n\n  void main() {\n    vec2 viewable = getViewable();\n\n    // calculate the gap-aware geometry\n    vec2 zoomedResolution = resolution / viewable;\n    vec2 gap = gapPx / zoomedResolution;\n\n    vec2 maxGapRatio = 1.0 - minFillRatio;\n    Geom g = getGeom(viewable, gap, maxGapRatio);\n\n    gl_Position = g.glPosition;\n    fragmentColor = g.fragmentColor;\n\n    // calculate rounded corner metrics for interpolation\n    vec2 pixelSize = g.size * zoomedResolution;\n    radiusPx = min(cornerRadiusPx, 0.5 * min(pixelSize.x, pixelSize.y));\n\n    // output the corner helper values  (approx. return values of our vertex shader)\n    corners[0] = g.unitSquareCoord * g.size * zoomedResolution - radiusPx;\n    corners[1] = (g.unitSquareCoord * vec2(-1, 1) + vec2(1, 0)) * g.size * zoomedResolution - radiusPx;\n    corners[2] = (g.unitSquareCoord * vec2(1, -1) + vec2(0, 1)) * g.size * zoomedResolution - radiusPx;\n    corners[3] = (1.0 - g.unitSquareCoord) * g.size * zoomedResolution - radiusPx;\n  }\n");
exports.roundedRectFrag = "".concat(fragTop, "\n  in vec4 fragmentColor;\n  in vec2 corners[4];\n  in float radiusPx;\n\n  out vec4 fragColor;\n\n  void main() {\n    if((   min(0.0, sign(corners[0].x) + sign(corners[0].y) + sign(radiusPx - length(corners[0])) + 2.0)\n         + min(0.0, sign(corners[1].x) + sign(corners[1].y) + sign(radiusPx - length(corners[1])) + 2.0)\n         + min(0.0, sign(corners[2].x) + sign(corners[2].y) + sign(radiusPx - length(corners[2])) + 2.0)\n         + min(0.0, sign(corners[3].x) + sign(corners[3].y) + sign(radiusPx - length(corners[3])) + 2.0)\n       ) < 0.0) discard;\n    fragColor = fragmentColor;\n  }\n");
exports.colorFrag = "".concat(fragTop, "\n  in vec4 fragmentColor;\n  out vec4 fragColor;\n  void main() { fragColor = fragmentColor; }\n");
//# sourceMappingURL=shaders.js.map