"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UXDashboardDatePicker = void 0;

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _moment = _interopRequireDefault(require("moment"));

var _utils = require("./utils");

/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const DEFAULT_ABS_START_UTC_DATE = '2022-05-22T19:00:00.000Z';
const DEFAULT_ABS_END_UTC_DATE = '2022-05-22T20:00:00.000Z';
const MOMENT_DATE_INPUT_FORMAT = 'MMM DD, YYYY @ HH:mm:ss:SSS';

class UXDashboardDatePicker {
  constructor(page) {
    (0, _defineProperty2.default)(this, "page", void 0);
    (0, _defineProperty2.default)(this, "dateStarButton", void 0);
    (0, _defineProperty2.default)(this, "dateEndButton", void 0);
    (0, _defineProperty2.default)(this, "datePopupAbsoluteTab", void 0);
    (0, _defineProperty2.default)(this, "dateAbsoluteInput", void 0);
    (0, _defineProperty2.default)(this, "dateApplyButton", void 0);
    this.page = page;
    this.dateStarButton = page.locator('.euiDatePopoverButton--start');
    this.dateEndButton = page.locator('.euiDatePopoverButton--end');
    this.datePopupAbsoluteTab = page.locator('text=Absolute');
    this.dateAbsoluteInput = page.locator((0, _utils.byTestId)('superDatePickerAbsoluteDateInput'));
    this.dateApplyButton = page.locator((0, _utils.byTestId)('superDatePickerApplyTimeButton'));
  }

  async setAbsoluteStartDate(dateStr) {
    await this.dateStarButton.first().click({
      timeout: 3 * 60 * 1000
    });
    await this.datePopupAbsoluteTab.first().click();
    await this.dateAbsoluteInput.first().click({
      clickCount: 3
    }); // clear input

    await this.dateAbsoluteInput.first().type(dateStr);
  }

  async setAbsoluteEndDate(dateStr) {
    await this.dateEndButton.first().click();
    await this.datePopupAbsoluteTab.first().click();
    await this.dateAbsoluteInput.first().click({
      clickCount: 3
    }); // clear input

    await this.dateAbsoluteInput.first().type(dateStr);
  }

  async applyDate() {
    await this.dateApplyButton.click();
  }

  async setDefaultE2eRange() {
    const startDateStr = (0, _moment.default)(DEFAULT_ABS_START_UTC_DATE).format(MOMENT_DATE_INPUT_FORMAT);
    await this.setAbsoluteStartDate(startDateStr);
    const endDateStr = (0, _moment.default)(DEFAULT_ABS_END_UTC_DATE).format(MOMENT_DATE_INPUT_FORMAT);
    await this.setAbsoluteEndDate(endDateStr);
    await this.applyDate();
  }

}

exports.UXDashboardDatePicker = UXDashboardDatePicker;