"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UXDashboardFilters = void 0;

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _utils = require("./utils");

/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
class UXDashboardFilters {
  constructor(page) {
    (0, _defineProperty2.default)(this, "page", void 0);
    (0, _defineProperty2.default)(this, "percentileSelect", void 0);
    this.page = page;
    this.percentileSelect = page.locator((0, _utils.byTestId)('uxPercentileSelect'));
  }

  getPercentileOption(percentile) {
    return this.page.locator((0, _utils.byTestId)(`p${percentile}Percentile`));
  }

}

exports.UXDashboardFilters = UXDashboardFilters;