"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SyntheticsMonitorClient = void 0;

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _synthetics_private_location = require("../private_location/synthetics_private_location");

var _format_configs = require("../formatters/format_configs");

var _runtime_types = require("../../../common/runtime_types");

/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
class SyntheticsMonitorClient {
  constructor(syntheticsService, server) {
    (0, _defineProperty2.default)(this, "syntheticsService", void 0);
    (0, _defineProperty2.default)(this, "privateLocationAPI", void 0);
    this.syntheticsService = syntheticsService;
    this.privateLocationAPI = new _synthetics_private_location.SyntheticsPrivateLocation(server);
  }

  async addMonitor(monitor, id, request, savedObjectsClient) {
    await this.syntheticsService.setupIndexTemplates();
    const config = (0, _format_configs.formatHeartbeatRequest)({
      monitor,
      monitorId: id,
      customHeartbeatId: monitor[_runtime_types.ConfigKey.CUSTOM_HEARTBEAT_ID]
    });
    const {
      privateLocations,
      publicLocations
    } = this.parseLocations(config);

    if (privateLocations.length > 0) {
      await this.privateLocationAPI.createMonitor(config, request, savedObjectsClient);
    }

    if (publicLocations.length > 0) {
      return await this.syntheticsService.addConfig(config);
    }
  }

  async editMonitor(editedMonitor, id, request, savedObjectsClient) {
    const editedConfig = (0, _format_configs.formatHeartbeatRequest)({
      monitor: editedMonitor,
      monitorId: id,
      customHeartbeatId: editedMonitor[_runtime_types.ConfigKey.CUSTOM_HEARTBEAT_ID]
    });
    const {
      publicLocations
    } = this.parseLocations(editedConfig);
    await this.privateLocationAPI.editMonitor(editedConfig, request, savedObjectsClient);

    if (publicLocations.length > 0) {
      return await this.syntheticsService.editConfig(editedConfig);
    }

    await this.syntheticsService.editConfig(editedConfig);
  }

  async deleteMonitor(monitor, request, savedObjectsClient) {
    await this.privateLocationAPI.deleteMonitor(monitor, request, savedObjectsClient);
    return await this.syntheticsService.deleteConfigs([monitor]);
  }

  parseLocations(config) {
    const {
      locations
    } = config;
    const privateLocations = locations.filter(loc => !loc.isServiceManaged);
    const publicLocations = locations.filter(loc => loc.isServiceManaged);
    return {
      privateLocations,
      publicLocations
    };
  }

}

exports.SyntheticsMonitorClient = SyntheticsMonitorClient;