"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.bulkCreateSavedObjects = void 0;

var savedObjectsToCreate = _interopRequireWildcard(require("../saved_object"));

function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }

function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const bulkCreateSavedObjects = async ({
  request,
  spaceId,
  savedObjectTemplate
}) => {
  const savedObjectsClient = (await request.context.core).savedObjects.client;
  const regex = /<REPLACE-WITH-SPACE>/g;
  const savedObjects = JSON.stringify(savedObjectsToCreate[savedObjectTemplate]);

  if (savedObjects == null) {
    return new Error('Template not found.');
  }

  const replacedSO = spaceId ? savedObjects.replace(regex, spaceId) : savedObjects;
  const createSO = await savedObjectsClient.bulkCreate(JSON.parse(replacedSO), {
    overwrite: true
  });
  return createSO;
};

exports.bulkCreateSavedObjects = bulkCreateSavedObjects;