"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isIndexPatternsBulkEditAction = void 0;

var _schemas = require("../../../../../common/detection_engine/schemas/common/schemas");

/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * helper utility that defines whether bulk edit action is related to index patterns, i.e. one of:
 * 'add_index_patterns', 'delete_index_patterns', 'set_index_patterns'
 * @param editAction {@link BulkActionEditType}
 * @returns {boolean}
 */
const isIndexPatternsBulkEditAction = editAction => [_schemas.BulkActionEditType.add_index_patterns, _schemas.BulkActionEditType.delete_index_patterns, _schemas.BulkActionEditType.set_index_patterns].includes(editAction);

exports.isIndexPatternsBulkEditAction = isIndexPatternsBulkEditAction;