"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.buildTimestampRuntimeMapping = exports.TIMESTAMP_RUNTIME_FIELD = void 0;

/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const TIMESTAMP_RUNTIME_FIELD = 'kibana.combined_timestamp';
exports.TIMESTAMP_RUNTIME_FIELD = TIMESTAMP_RUNTIME_FIELD;

const buildTimestampRuntimeMapping = ({
  timestampOverride
}) => {
  return {
    [TIMESTAMP_RUNTIME_FIELD]: {
      type: 'date',
      script: {
        source: `
              if (doc.containsKey(params.timestampOverride) && doc[params.timestampOverride].size()!=0) {
                emit(doc[params.timestampOverride].value.millis);
              } else {
                emit(doc['@timestamp'].value.millis);
              }
            `,
        params: {
          timestampOverride
        }
      }
    }
  };
};

exports.buildTimestampRuntimeMapping = buildTimestampRuntimeMapping;