"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.checkInFleetAgent = void 0;

var _common = require("../../../../fleet/common");

/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const checkInFleetAgent = async (esClient, agentId) => {
  const checkinNow = new Date().toISOString();
  await esClient.update({
    index: _common.AGENTS_INDEX,
    id: agentId,
    refresh: 'wait_for',
    retry_on_conflict: 5,
    body: {
      doc: {
        active: true,
        last_checkin: checkinNow,
        updated_at: checkinNow
      }
    }
  });
};

exports.checkInFleetAgent = checkInFleetAgent;