"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.cli = void 0;

var _devCliRunner = require("@kbn/dev-cli-runner");

var _constants = require("./constants");

var _run_in_auto_mode = require("./run_in_auto_mode");

/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const cli = () => {
  (0, _devCliRunner.run)(async context => {
    context.log.write(`
${_constants.HORIZONTAL_LINE}
 Endpoint Action Responder
${_constants.HORIZONTAL_LINE}
`);

    if (context.flags.mode === 'auto') {
      return (0, _run_in_auto_mode.runInAutoMode)(context);
    }

    context.log.warning(`exiting... Nothing to do. use '--help' to see list of options`);
    context.log.write(`
${_constants.HORIZONTAL_LINE}
`);
  }, {
    description: `Respond to pending Endpoint actions.
  ${_constants.SUPPORTED_TOKENS}`,
    flags: {
      string: ['mode', 'kibana', 'elastic', 'username', 'password', 'delay'],
      boolean: ['asSuperuser'],
      default: {
        mode: 'auto',
        kibana: 'http://localhost:5601',
        elastic: 'http://localhost:9200',
        username: 'elastic',
        password: 'changeme',
        asSuperuser: false,
        delay: ''
      },
      help: `
        --mode              The mode for running the tool. (Default: 'auto').
                            Value values are:
                            auto  : tool will continue to run and checking for pending
                                    actions periodically.
        --username          User name to be used for auth against elasticsearch and
                            kibana (Default: elastic).
                            **IMPORTANT:** This username's roles MUST have 'superuser']
                            and 'kibana_system' roles
        --password          User name Password (Default: changeme)
        --asSuperuser       If defined, then a Security super user will be created using the
                            the credentials defined via 'username' and 'password' options. This
                            new user will then be used to run this utility.
        --delay             The delay (in milliseconds) that should be applied before responding
                            to an action. (Default: 40000 (40s))
        --kibana            The url to Kibana (Default: http://localhost:5601)
        --elastic           The url to Elasticsearch (Default: http:localholst:9200)
      `
    }
  });
};

exports.cli = cli;