"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getTopDependencySpans = getTopDependencySpans;

var _server = require("../../../../observability/server");

var _lodash = require("lodash");

var _elasticsearch_fieldnames = require("../../../common/elasticsearch_fieldnames");

var _event_outcome = require("../../../common/event_outcome");

var _processor_event = require("../../../common/processor_event");

var _environment_query = require("../../../common/utils/environment_query");

/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const MAX_NUM_SPANS = 1000;

async function getTopDependencySpans({
  setup,
  dependencyName,
  spanName,
  start,
  end,
  environment,
  kuery,
  sampleRangeFrom,
  sampleRangeTo
}) {
  const {
    apmEventClient
  } = setup;
  const spans = (await apmEventClient.search('get_top_dependency_spans', {
    apm: {
      events: [_processor_event.ProcessorEvent.span]
    },
    body: {
      size: MAX_NUM_SPANS,
      query: {
        bool: {
          filter: [...(0, _server.rangeQuery)(start, end), ...(0, _environment_query.environmentQuery)(environment), ...(0, _server.kqlQuery)(kuery), ...(0, _server.termQuery)(_elasticsearch_fieldnames.SPAN_DESTINATION_SERVICE_RESOURCE, dependencyName), ...(0, _server.termQuery)(_elasticsearch_fieldnames.SPAN_NAME, spanName), ...((sampleRangeFrom !== null && sampleRangeFrom !== void 0 ? sampleRangeFrom : 0) >= 0 && (sampleRangeTo !== null && sampleRangeTo !== void 0 ? sampleRangeTo : 0) > 0 ? [{
            range: {
              [_elasticsearch_fieldnames.SPAN_DURATION]: {
                gte: sampleRangeFrom,
                lte: sampleRangeTo
              }
            }
          }] : [])]
        }
      },
      _source: [_elasticsearch_fieldnames.TRACE_ID, _elasticsearch_fieldnames.TRANSACTION_ID, _elasticsearch_fieldnames.SPAN_NAME, _elasticsearch_fieldnames.SERVICE_NAME, _elasticsearch_fieldnames.SERVICE_ENVIRONMENT, _elasticsearch_fieldnames.AGENT_NAME, _elasticsearch_fieldnames.SPAN_DURATION, _elasticsearch_fieldnames.EVENT_OUTCOME, '@timestamp']
    }
  })).hits.hits.map(hit => hit._source);
  const transactionIds = (0, _lodash.compact)(spans.map(span => {
    var _span$transaction;

    return (_span$transaction = span.transaction) === null || _span$transaction === void 0 ? void 0 : _span$transaction.id;
  }));
  const transactions = (await apmEventClient.search('get_transactions_for_dependency_spans', {
    apm: {
      events: [_processor_event.ProcessorEvent.transaction]
    },
    body: {
      size: transactionIds.length,
      query: {
        bool: {
          filter: [...(0, _server.termsQuery)(_elasticsearch_fieldnames.TRANSACTION_ID, ...transactionIds)]
        }
      },
      _source: [_elasticsearch_fieldnames.TRANSACTION_ID, _elasticsearch_fieldnames.TRANSACTION_TYPE, _elasticsearch_fieldnames.TRANSACTION_NAME],
      sort: {
        '@timestamp': 'desc'
      }
    }
  })).hits.hits.map(hit => hit._source);
  const transactionsById = (0, _lodash.keyBy)(transactions, transaction => transaction.transaction.id);
  return spans.map(span => {
    var _span$event;

    const transaction = span.transaction ? transactionsById[span.transaction.id] : undefined;
    return {
      '@timestamp': new Date(span['@timestamp']).getTime(),
      spanName: span.span.name,
      serviceName: span.service.name,
      agentName: span.agent.name,
      duration: span.span.duration.us,
      traceId: span.trace.id,
      outcome: ((_span$event = span.event) === null || _span$event === void 0 ? void 0 : _span$event.outcome) || _event_outcome.EventOutcome.unknown,
      transactionId: transaction === null || transaction === void 0 ? void 0 : transaction.transaction.id,
      transactionType: transaction === null || transaction === void 0 ? void 0 : transaction.transaction.type,
      transactionName: transaction === null || transaction === void 0 ? void 0 : transaction.transaction.name
    };
  });
}