"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ChangeListeners = void 0;

var _react = _interopRequireWildcard(require("react"));

var _addonActions = require("@storybook/addon-actions");

var _eui = require("@elastic/eui");

var _components = require("../../../components");

var _use_form_data = require("../../hooks/use_form_data");

var _use_field = require("../use_field");

function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }

function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/**
 * This Story outputs the order in which different state update
 * and events occur whenever a field value changes.
 */
const ChangeListeners = () => {
  const onUseFormDataChange = ({
    title
  }) => {
    (0, _addonActions.action)('1. useFormData() -> onChange() handler')(title);
  };

  const [{
    title
  }] = (0, _use_form_data.useFormData)({
    watch: 'title',
    onChange: onUseFormDataChange
  });

  const onFieldChangeProp = value => {
    (0, _addonActions.action)('2. onChange() prop handler')(value);
  };

  (0, _react.useEffect)(() => {
    (0, _addonActions.action)('4. useEffect() "title" changed')(title);
    (0, _addonActions.action)('')('----------------------------------');
  }, [title]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
    color: "subdued"
  }, "Info: start writing in the field and see the order of change listeners appear in the \"Actions\" panel below."))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_use_field.UseField, {
    path: "title",
    component: _components.TextField,
    config: {
      label: 'Title',
      helpText: 'This is a help text for the field.',
      validations: [{
        validator: ({
          value
        }) => {
          (0, _addonActions.action)('3. Validating "title" field')(value);
        }
      }]
    },
    onChange: onFieldChangeProp
  }));
};

exports.ChangeListeners = ChangeListeners;
ChangeListeners.storyName = 'ChangeListeners';
ChangeListeners.parameters = {
  docs: {
    source: {
      code: `
const MyFormComponent = () => {
  const { form } = useForm({ defaultValue });

  const onUseFormDataChange = ({ title }: { title: string }) => {
    action('1. useFormData() -> onChange() handler')(title);
  };
  const [{ title }] = useFormData({ watch: 'title', onChange: onUseFormDataChange });

  const onFieldChangeProp = (value: string) => {
    action('2. onChange() prop handler')(value);
  };

  useEffect(() => {
    action('4. useEffect() "title" changed')(title);
    action('')('----------------------------------');
  }, [title]);

  const submitForm = async () => {
    const { isValid, data } = await form.submit();
    if (isValid) {
      // ... do something with the data
    }
  };

  return (
    <Form form={form}>
      <EuiText>
        <p>
          <EuiTextColor color="subdued">
            Info: start writing in the field and see the order of change listeners appear in the
            &quot;Actions&quot; panel below.
          </EuiTextColor>
        </p>
      </EuiText>
      <EuiSpacer />
      <UseField<string>
        path="title"
        component={TextField}
        config={{
          label: 'Title',
          helpText: 'This is a help text for the field.',
          validations: [
            {
              validator: ({ value }) => {
                action('3. Validating "title" field')(value);
              },
            },
          ],
        }}
        onChange={onFieldChangeProp}
      />
      <EuiSpacer />
      <EuiButton onClick={submitForm}>Send</EuiButton>
    </Form>
  );
};
      `,
      language: 'tsx'
    }
  }
};