import _defineProperty from "@babel/runtime/helpers/defineProperty";
import _objectSpread from "@babel/runtime/helpers/objectSpread2";

/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/**
 * registering a new instance of the rule data client
 * in a new plugin will require updating the below data structure
 * to include the index name where the alerts as data will be written to.
 */
export var AlertConsumers = {
  APM: 'apm',
  LOGS: 'logs',
  INFRASTRUCTURE: 'infrastructure',
  OBSERVABILITY: 'observability',
  SIEM: 'siem',
  UPTIME: 'uptime'
};
export var validFeatureIds = Object.values(AlertConsumers).map(function (v) {
  return v;
});
export var isValidFeatureId = function isValidFeatureId(a) {
  return typeof a === 'string' && validFeatureIds.includes(a);
};
/**
 * Prevent javascript from returning Number.MAX_SAFE_INTEGER when Elasticsearch expects
 * Java's Long.MAX_VALUE. This happens when sorting fields by date which are
 * unmapped in the provided index
 *
 * Ref: https://github.com/elastic/elasticsearch/issues/28806#issuecomment-369303620
 *
 * return stringified Long.MAX_VALUE if we receive Number.MAX_SAFE_INTEGER
 * @param sortIds estypes.SortResults | undefined
 * @returns SortResults
 */

export var getSafeSortIds = function getSafeSortIds(sortIds) {
  if (sortIds == null) {
    return sortIds;
  }

  return sortIds.map(function (sortId) {
    // haven't determined when we would receive a null value for a sort id
    // but in case we do, default to sending the stringified Java max_int
    if (sortId == null || sortId === '' || sortId >= Number.MAX_SAFE_INTEGER) {
      return '9223372036854775807';
    }

    return sortId;
  });
};
export var getEsQueryConfig = function getEsQueryConfig(params) {
  var defaultConfigValues = {
    allowLeadingWildcards: true,
    queryStringOptions: {
      analyze_wildcard: true
    },
    ignoreFilterIfFieldNotInIndex: false,
    dateFormatTZ: 'Zulu'
  };

  if (params == null) {
    return defaultConfigValues;
  }

  var paramKeysWithValues = Object.keys(params).reduce(function (acc, key) {
    var configKey = key;

    if (params[configKey] != null) {
      return _objectSpread(_defineProperty({}, key, params[configKey]), acc);
    }

    return _objectSpread(_defineProperty({}, key, defaultConfigValues[configKey]), acc);
  }, {});
  return paramKeysWithValues;
};