/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
import * as t from 'io-ts';
import { either } from 'fp-ts/lib/Either'; // Checks whether a string is a valid ISO timestamp,
// and returns an epoch timestamp

export var isoToEpochRt = new t.Type('isoToEpochRt', t.number.is, function (input, context) {
  return either.chain(t.string.validate(input, context), function (str) {
    var epochDate = new Date(str).getTime();
    return isNaN(epochDate) ? t.failure(input, context) : t.success(epochDate);
  });
}, function (output) {
  return new Date(output).toISOString();
});