"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.monitorEventLoopDelay = void 0;

var _mocks_internal = require("../mocks_internal");

/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
const monitorEventLoopDelay = jest.fn().mockImplementation(() => {
  const mockedHistogram = _mocks_internal.mocked.createHistogram();

  return { ...mockedHistogram,
    enable: jest.fn(),
    percentile: jest.fn().mockImplementation(percentile => {
      return mockedHistogram.percentiles[`${percentile}`];
    }),
    disable: jest.fn(),
    reset: jest.fn()
  };
});
exports.monitorEventLoopDelay = monitorEventLoopDelay;