"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.rollingFileAppenderMocks = void 0;

/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
const createContextMock = filePath => {
  const mock = {
    currentFileSize: 0,
    currentFileTime: 0,
    filePath,
    refreshFileInfo: jest.fn()
  };
  return mock;
};

const createStrategyMock = () => {
  const mock = {
    rollout: jest.fn()
  };
  return mock;
};

const createPolicyMock = () => {
  const mock = {
    isTriggeringEvent: jest.fn()
  };
  return mock;
};

const createLayoutMock = () => {
  const mock = {
    format: jest.fn()
  };
  return mock;
};

const createFileManagerMock = () => {
  const mock = {
    write: jest.fn(),
    closeStream: jest.fn()
  };
  return mock;
};

const rollingFileAppenderMocks = {
  createContext: createContextMock,
  createStrategy: createStrategyMock,
  createPolicy: createPolicyMock,
  createLayout: createLayoutMock,
  createFileManager: createFileManagerMock
};
exports.rollingFileAppenderMocks = rollingFileAppenderMocks;