"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getReservedHeaders = void 0;

var _coreElasticsearchClientServerInternal = require("@kbn/core-elasticsearch-client-server-internal");

/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
const getReservedHeaders = headerNames => {
  const reservedHeaders = [];

  for (const headerName of headerNames) {
    if (_coreElasticsearchClientServerInternal.RESERVED_HEADERS.includes(headerName.toLowerCase())) {
      reservedHeaders.push(headerName);
    }
  }

  return reservedHeaders;
};

exports.getReservedHeaders = getReservedHeaders;