import _extends from "@babel/runtime/helpers/extends";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
var _excluded = ["palettes", "activePalette", "setPalette", "showCustomPalette", "showDynamicColorOnly"];

/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
import React from 'react';
import { EuiColorPalettePicker } from '@elastic/eui';
import { CUSTOM_PALETTE, DEFAULT_COLOR_STEPS, FIXED_PROGRESSION, DEFAULT_PALETTE_NAME } from '../../palettes';
import { jsx as ___EmotionJSX } from "@emotion/react";

function getCustomPaletteConfig(palettes, activePalette) {
  var _activePalette$params3;

  var _palettes$get = palettes.get(CUSTOM_PALETTE),
      id = _palettes$get.id,
      title = _palettes$get.title; // Try to generate a palette from the current one


  if (activePalette && activePalette.name !== CUSTOM_PALETTE) {
    var currentPalette = palettes.get(activePalette.name);

    if (currentPalette) {
      var _activePalette$params, _activePalette$params2;

      var stops = currentPalette.getCategoricalColors((activePalette === null || activePalette === void 0 ? void 0 : (_activePalette$params = activePalette.params) === null || _activePalette$params === void 0 ? void 0 : _activePalette$params.steps) || DEFAULT_COLOR_STEPS, activePalette === null || activePalette === void 0 ? void 0 : activePalette.params);

      var _palette = (_activePalette$params2 = activePalette.params) !== null && _activePalette$params2 !== void 0 && _activePalette$params2.reverse ? stops.reverse() : stops;

      return {
        value: id,
        title: title,
        type: FIXED_PROGRESSION,
        palette: _palette,
        'data-test-subj': "custom-palette"
      };
    }
  } // if not possible just show some text


  if (!(activePalette !== null && activePalette !== void 0 && (_activePalette$params3 = activePalette.params) !== null && _activePalette$params3 !== void 0 && _activePalette$params3.stops)) {
    return {
      value: id,
      title: title,
      type: 'text',
      'data-test-subj': "custom-palette"
    };
  } // full custom palette


  return {
    value: id,
    title: title,
    type: FIXED_PROGRESSION,
    'data-test-subj': "custom-palette",
    palette: (activePalette.params.colorStops || activePalette.params.stops).map(function (colorStop) {
      return colorStop.color;
    })
  };
} // Note: this is a special palette picker different from the one in the root shared folder
// ideally these should be merged together, but as for now this holds some custom logic hard to remove


export function PalettePicker(_ref) {
  var palettes = _ref.palettes,
      activePalette = _ref.activePalette,
      setPalette = _ref.setPalette,
      showCustomPalette = _ref.showCustomPalette,
      showDynamicColorOnly = _ref.showDynamicColorOnly,
      rest = _objectWithoutProperties(_ref, _excluded);

  var palettesToShow = palettes.getAll().filter(function (_ref2) {
    var internal = _ref2.internal,
        canDynamicColoring = _ref2.canDynamicColoring;
    return showDynamicColorOnly ? canDynamicColoring : !internal;
  }).map(function (_ref3) {
    var _activePalette$params4;

    var id = _ref3.id,
        title = _ref3.title,
        getCategoricalColors = _ref3.getCategoricalColors;
    var colors = getCategoricalColors((activePalette === null || activePalette === void 0 ? void 0 : (_activePalette$params4 = activePalette.params) === null || _activePalette$params4 === void 0 ? void 0 : _activePalette$params4.steps) || DEFAULT_COLOR_STEPS, id === (activePalette === null || activePalette === void 0 ? void 0 : activePalette.name) ? activePalette === null || activePalette === void 0 ? void 0 : activePalette.params : undefined);
    return {
      value: id,
      title: title,
      type: FIXED_PROGRESSION,
      palette: colors,
      'data-test-subj': "".concat(id, "-palette")
    };
  });

  if (showCustomPalette) {
    palettesToShow.push(getCustomPaletteConfig(palettes, activePalette));
  }

  return ___EmotionJSX(EuiColorPalettePicker, _extends({
    fullWidth: true,
    "data-test-subj": "lns-palettePicker",
    compressed: true,
    palettes: palettesToShow,
    onChange: function onChange(newPalette) {
      setPalette({
        type: 'palette',
        name: newPalette
      });
    },
    valueOfSelected: (activePalette === null || activePalette === void 0 ? void 0 : activePalette.name) || DEFAULT_PALETTE_NAME,
    selectionDisplay: "palette"
  }, rest));
}