/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
import { DEFAULT_CONTINUITY, DEFAULT_RANGE_TYPE } from '../../palettes';
import { addColorRange, deleteColorRange, distributeEqually, reversePalette, sortColorRanges, updateColorRangeColor, updateColorRangeValue, getValueForContinuity } from './color_ranges/utils';
import { mergePaletteParams, updateRangeType, changeColorPalette, withUpdatingPalette, withUpdatingColorRanges } from './utils';
export var paletteConfigurationReducer = function paletteConfigurationReducer(state, action) {
  switch (action.type) {
    case 'updateContinuity':
      {
        var _state$activePalette$, _state$activePalette$2;

        var _action$payload = action.payload,
            continuity = _action$payload.continuity,
            isLast = _action$payload.isLast,
            dataBounds = _action$payload.dataBounds,
            palettes = _action$payload.palettes;
        var rangeType = (_state$activePalette$ = (_state$activePalette$2 = state.activePalette.params) === null || _state$activePalette$2 === void 0 ? void 0 : _state$activePalette$2.rangeType) !== null && _state$activePalette$ !== void 0 ? _state$activePalette$ : DEFAULT_RANGE_TYPE;
        var value = getValueForContinuity(state.colorRanges, continuity, isLast, rangeType, dataBounds);
        return withUpdatingPalette(palettes, state.activePalette, updateColorRangeValue(isLast ? state.colorRanges.length - 1 : 0, "".concat(value), isLast ? 'end' : 'start', state.colorRanges), dataBounds, continuity);
      }

    case 'addColorRange':
      {
        var _state$activePalette$3, _state$activePalette$4;

        var _action$payload2 = action.payload,
            _dataBounds = _action$payload2.dataBounds,
            _palettes = _action$payload2.palettes;
        return withUpdatingPalette(_palettes, state.activePalette, addColorRange(state.colorRanges, (_state$activePalette$3 = (_state$activePalette$4 = state.activePalette.params) === null || _state$activePalette$4 === void 0 ? void 0 : _state$activePalette$4.rangeType) !== null && _state$activePalette$3 !== void 0 ? _state$activePalette$3 : DEFAULT_RANGE_TYPE, _dataBounds), _dataBounds);
      }

    case 'reversePalette':
      {
        var _action$payload3 = action.payload,
            _dataBounds2 = _action$payload3.dataBounds,
            _palettes2 = _action$payload3.palettes;
        return withUpdatingPalette(_palettes2, state.activePalette, reversePalette(state.colorRanges), _dataBounds2);
      }

    case 'distributeEqually':
      {
        var _state$activePalette$5, _state$activePalette$6, _state$activePalette$7;

        var _action$payload4 = action.payload,
            _dataBounds3 = _action$payload4.dataBounds,
            _palettes3 = _action$payload4.palettes;
        return withUpdatingPalette(_palettes3, state.activePalette, distributeEqually(state.colorRanges, (_state$activePalette$5 = state.activePalette.params) === null || _state$activePalette$5 === void 0 ? void 0 : _state$activePalette$5.rangeType, (_state$activePalette$6 = (_state$activePalette$7 = state.activePalette.params) === null || _state$activePalette$7 === void 0 ? void 0 : _state$activePalette$7.continuity) !== null && _state$activePalette$6 !== void 0 ? _state$activePalette$6 : DEFAULT_CONTINUITY, _dataBounds3), _dataBounds3);
      }

    case 'updateColor':
      {
        var _action$payload5 = action.payload,
            index = _action$payload5.index,
            color = _action$payload5.color,
            _palettes4 = _action$payload5.palettes,
            _dataBounds4 = _action$payload5.dataBounds;
        return withUpdatingPalette(_palettes4, state.activePalette, updateColorRangeColor(index, color, state.colorRanges), _dataBounds4);
      }

    case 'sortColorRanges':
      {
        var _action$payload6 = action.payload,
            _dataBounds5 = _action$payload6.dataBounds,
            _palettes5 = _action$payload6.palettes;
        return withUpdatingPalette(_palettes5, state.activePalette, sortColorRanges(state.colorRanges), _dataBounds5);
      }

    case 'updateValue':
      {
        var _action$payload7 = action.payload,
            _index = _action$payload7.index,
            _value = _action$payload7.value,
            accessor = _action$payload7.accessor,
            _dataBounds6 = _action$payload7.dataBounds,
            _palettes6 = _action$payload7.palettes;
        return withUpdatingPalette(_palettes6, state.activePalette, updateColorRangeValue(_index, _value, accessor, state.colorRanges), _dataBounds6);
      }

    case 'deleteColorRange':
      {
        var _action$payload8 = action.payload,
            _index2 = _action$payload8.index,
            _dataBounds7 = _action$payload8.dataBounds,
            _palettes7 = _action$payload8.palettes;
        return withUpdatingPalette(_palettes7, state.activePalette, deleteColorRange(_index2, state.colorRanges), _dataBounds7);
      }

    case 'updateRangeType':
      {
        var _action$payload9 = action.payload,
            _dataBounds8 = _action$payload9.dataBounds,
            _palettes8 = _action$payload9.palettes,
            _rangeType = _action$payload9.rangeType;
        var paletteParams = updateRangeType(_rangeType, state.activePalette, _dataBounds8, _palettes8, state.colorRanges);
        var newPalette = mergePaletteParams(state.activePalette, paletteParams);
        return withUpdatingColorRanges(_palettes8, newPalette, _dataBounds8);
      }

    case 'changeColorPalette':
      {
        var _action$payload10 = action.payload,
            _dataBounds9 = _action$payload10.dataBounds,
            _palettes9 = _action$payload10.palettes,
            palette = _action$payload10.palette,
            disableSwitchingContinuity = _action$payload10.disableSwitchingContinuity;

        var _newPalette = changeColorPalette(palette, state.activePalette, _palettes9, _dataBounds9, disableSwitchingContinuity);

        return withUpdatingColorRanges(_palettes9, _newPalette, _dataBounds9);
      }

    default:
      throw new Error('wrong action');
  }
};