import _slicedToArray from "@babel/runtime/helpers/slicedToArray";

/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
import { i18n } from '@kbn/i18n';
import React, { useReducer, useMemo } from 'react';
import useDebounce from 'react-use/lib/useDebounce';
import { css } from '@emotion/react';
import { EuiFormRow, htmlIdGenerator, EuiButtonGroup, EuiIconTip, useEuiTheme } from '@elastic/eui';
import { PalettePicker } from './palette_picker';
import { getFallbackDataBounds } from '../../palettes';
import { toColorRanges } from './utils';
import { ColorRanges, ColorRangesContext } from './color_ranges';
import { isAllColorRangesValid } from './color_ranges/color_ranges_validation';
import { paletteConfigurationReducer } from './palette_configuration_reducer';
import { jsx as ___EmotionJSX } from "@emotion/react";
export var CustomizablePalette = function CustomizablePalette(_ref) {
  var _activePalette$params, _activePalette$params2, _localState$activePal, _localState$activePal2, _localState$activePal3;

  var palettes = _ref.palettes,
      activePalette = _ref.activePalette,
      setPalette = _ref.setPalette,
      _ref$dataBounds = _ref.dataBounds,
      dataBounds = _ref$dataBounds === void 0 ? getFallbackDataBounds((_activePalette$params = activePalette.params) === null || _activePalette$params === void 0 ? void 0 : _activePalette$params.rangeType) : _ref$dataBounds,
      _ref$showExtraActions = _ref.showExtraActions,
      showExtraActions = _ref$showExtraActions === void 0 ? true : _ref$showExtraActions,
      _ref$showRangeTypeSel = _ref.showRangeTypeSelector,
      showRangeTypeSelector = _ref$showRangeTypeSel === void 0 ? true : _ref$showRangeTypeSel,
      _ref$disableSwitching = _ref.disableSwitchingContinuity,
      disableSwitchingContinuity = _ref$disableSwitching === void 0 ? false : _ref$disableSwitching;
  var idPrefix = useMemo(function () {
    return htmlIdGenerator()();
  }, []);
  var colorRangesToShow = toColorRanges(palettes, ((_activePalette$params2 = activePalette.params) === null || _activePalette$params2 === void 0 ? void 0 : _activePalette$params2.colorStops) || [], activePalette, dataBounds);

  var _useReducer = useReducer(paletteConfigurationReducer, {
    activePalette: activePalette,
    colorRanges: colorRangesToShow
  }),
      _useReducer2 = _slicedToArray(_useReducer, 2),
      localState = _useReducer2[0],
      dispatch = _useReducer2[1];

  useDebounce(function () {
    if ((localState.activePalette !== activePalette || colorRangesToShow !== localState.colorRanges) && isAllColorRangesValid(localState.colorRanges)) {
      setPalette(localState.activePalette);
    }
  }, 250, [localState]);

  var _useEuiTheme = useEuiTheme(),
      euiTheme = _useEuiTheme.euiTheme;

  var styles = useMemo(function () {
    return /*#__PURE__*/css("padding:", euiTheme.size.base, ";background-color:", euiTheme.colors.lightestShade, ";border-bottom:", euiTheme.border.thin, ";" + (process.env.NODE_ENV === "production" ? "" : ";label:palette_configuration--styles;"), process.env.NODE_ENV === "production" ? "" : "/*# sourceMappingURL=data:application/json;charset=utf-8;base64,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 */");
  }, [euiTheme.size.base, euiTheme.colors.lightestShade, euiTheme.border.thin]);
  return ___EmotionJSX("div", {
    css: styles,
    className: "lnsPalettePanel__section"
  }, ___EmotionJSX(EuiFormRow, {
    display: "rowCompressed",
    label: i18n.translate('coloring.dynamicColoring.palettePicker.label', {
      defaultMessage: 'Color palette'
    }),
    fullWidth: true
  }, ___EmotionJSX(PalettePicker, {
    "data-test-subj": "lnsPalettePanel_dynamicColoring_palette_picker",
    palettes: palettes,
    activePalette: localState.activePalette,
    setPalette: function setPalette(newPalette) {
      var isPaletteChanged = newPalette.name !== activePalette.name;

      if (isPaletteChanged) {
        dispatch({
          type: 'changeColorPalette',
          payload: {
            palette: newPalette,
            dataBounds: dataBounds,
            palettes: palettes,
            disableSwitchingContinuity: disableSwitchingContinuity
          }
        });
      }
    },
    showCustomPalette: true,
    showDynamicColorOnly: true
  })), showRangeTypeSelector && ___EmotionJSX(EuiFormRow, {
    fullWidth: true,
    label: ___EmotionJSX(React.Fragment, null, i18n.translate('coloring.dynamicColoring.rangeType.label', {
      defaultMessage: 'Value type'
    }), ' ', ___EmotionJSX(EuiIconTip, {
      content: i18n.translate('coloring.dynamicColoring.customPalette.colorStopsHelpPercentage', {
        defaultMessage: 'Percent value types are relative to the full range of available data values.'
      }),
      position: "top",
      size: "s"
    })),
    display: "rowCompressed"
  }, ___EmotionJSX(EuiButtonGroup, {
    isFullWidth: true,
    legend: i18n.translate('coloring.dynamicColoring.rangeType.label', {
      defaultMessage: 'Value type'
    }),
    "data-test-subj": "lnsPalettePanel_dynamicColoring_custom_range_groups",
    name: "dynamicColoringRangeType",
    buttonSize: "compressed",
    options: [{
      id: "".concat(idPrefix, "percent"),
      label: i18n.translate('coloring.dynamicColoring.rangeType.percent', {
        defaultMessage: 'Percent'
      }),
      'data-test-subj': 'lnsPalettePanel_dynamicColoring_rangeType_groups_percent'
    }, {
      id: "".concat(idPrefix, "number"),
      label: i18n.translate('coloring.dynamicColoring.rangeType.number', {
        defaultMessage: 'Number'
      }),
      'data-test-subj': 'lnsPalettePanel_dynamicColoring_rangeType_groups_number'
    }],
    idSelected: (_localState$activePal = localState.activePalette.params) !== null && _localState$activePal !== void 0 && _localState$activePal.rangeType ? "".concat(idPrefix).concat((_localState$activePal2 = localState.activePalette.params) === null || _localState$activePal2 === void 0 ? void 0 : _localState$activePal2.rangeType) : "".concat(idPrefix, "percent"),
    onChange: function onChange(id) {
      var newRangeType = id.replace(idPrefix, '');
      dispatch({
        type: 'updateRangeType',
        payload: {
          rangeType: newRangeType,
          dataBounds: dataBounds,
          palettes: palettes
        }
      });
    }
  })), ___EmotionJSX(EuiFormRow, {
    label: i18n.translate('coloring.dynamicColoring.palettePicker.colorRangesLabel', {
      defaultMessage: 'Color Ranges'
    }),
    display: "rowCompressed",
    fullWidth: true
  }, ___EmotionJSX(ColorRangesContext.Provider, {
    value: {
      dataBounds: dataBounds,
      palettes: palettes,
      disableSwitchingContinuity: disableSwitchingContinuity
    }
  }, ___EmotionJSX(ColorRanges, {
    showExtraActions: showExtraActions,
    paletteConfiguration: (_localState$activePal3 = localState.activePalette) === null || _localState$activePal3 === void 0 ? void 0 : _localState$activePal3.params,
    colorRanges: localState.colorRanges,
    dispatch: dispatch
  }))));
};